/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query.apply;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.util.CdsModelUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.queryoption.apply.AggregateExpression;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;

public class ElementAggregator {
    private static final String UNIT_OR_CURRENCY = "unit or currency";
    private final ExpressionParser expressionParser;

    public ElementAggregator(ExpressionParser expressionParser) {
        this.expressionParser = expressionParser;
    }

    public Value<?> genericAggregate(Expression expr, AggregateExpression.StandardMethod standardMethod) {
        Value value = (Value)this.expressionParser.parseValue(expr);
        return this.toFunctionCall(value, standardMethod);
    }

    public Value<?> customAggregate(List<UriResource> path) {
        ElementRef ref = CQL.get(this.expressionParser.toSegmentList(path));
        return this.customAggregate((ElementRef<Object>)ref);
    }

    public Value<?> customAggregate(ElementRef<Object> ref) {
        if (ref.lastSegment().equals("$count")) {
            return CQL.count();
        }
        CdsElement element = CdsModelUtils.element((CdsStructuredType)this.expressionParser.getRootType(), ref);
        CustomAggregate aggMethod = this.getAggregationMethodName(element);
        return this.toFunctionCall(ref, aggMethod);
    }

    private CustomAggregate getAggregationMethodName(CdsElement element) {
        String methodName = ElementAggregator.getAnnoValue(element, CdsAnnotations.AGGREGATION_DEFAULT);
        if (methodName != null) {
            String unitOrCurrencyRef = ElementAggregator.getAnnoValue(element, CdsAnnotations.SEMANTICS_UNIT_OR_CURRENCY_REF);
            return CustomAggregate.of(methodName, unitOrCurrencyRef);
        }
        if (CdsAnnotations.SEMANTICS_CURRENCY_CODE.isTrue((CdsAnnotatable)element) || CdsAnnotations.SEMANTICS_UNIT_OF_MEASURE.isTrue((CdsAnnotatable)element)) {
            return CustomAggregate.of(UNIT_OR_CURRENCY);
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NO_CUSTOM_AGGREGATE_DEFINED, new Object[]{element});
    }

    Value<?> toFunctionCall(ElementRef<Object> ref, CustomAggregate aggMethod) {
        String methodName;
        Value<?> aggFunc = switch (methodName = aggMethod.methodName()) {
            case "AVG", "AVERAGE" -> ref.average();
            case "COUNT" -> CQL.count(ref);
            case "COUNT_DISTINCT" -> ref.countDistinct();
            case "MIN", "MAX", "SUM" -> this.typed((Value<?>)CQL.func((String)methodName, (CqnValue[])new CqnValue[]{ref}), (Value<?>)ref);
            case UNIT_OR_CURRENCY -> this.typed((Value<?>)CQL.when((CqnPredicate)ref.max().isNull()).then((CqnValue)CQL.constant((Object)"")).when((CqnPredicate)ref.min().eq((Value)ref.max())).then((CqnValue)ref.min()).orElse((CqnValue)CQL.NULL), (Value<?>)ref);
            default -> throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNKONWN_AGGREGATION_METHOD, new Object[]{aggMethod});
        };
        if (aggMethod.hasUnitOfMeasure()) {
            ElementRef<String> uom = aggMethod.unitOfMeasureRef();
            aggFunc = CQL.when((CqnPredicate)uom.min().eq((Value)uom.max())).then(aggFunc).orElse((CqnValue)CQL.NULL);
        }
        return aggFunc;
    }

    private Value<?> typed(Value<?> functionCall, Value<?> ref) {
        this.type(ref).ifPresent(arg_0 -> functionCall.type(arg_0));
        return functionCall;
    }

    public Value<?> toFunctionCall(Value<?> value, AggregateExpression.StandardMethod standardMethod) {
        return switch (standardMethod) {
            case AggregateExpression.StandardMethod.AVERAGE -> value.average();
            case AggregateExpression.StandardMethod.COUNT_DISTINCT -> value.countDistinct();
            case AggregateExpression.StandardMethod.MIN -> this.typed((Value<?>)value.min(), value);
            case AggregateExpression.StandardMethod.MAX -> this.typed((Value<?>)value.max(), value);
            default -> CQL.func((String)standardMethod.name(), (CqnValue[])new CqnValue[]{value});
        };
    }

    private Optional<CdsBaseType> type(Value<?> value) {
        CdsType t;
        if (value.isRef() && (t = CdsModelUtils.element((CdsStructuredType)this.expressionParser.getRootType(), (CqnElementRef)value.asRef()).getType()).isSimple()) {
            return Optional.ofNullable(((CdsSimpleType)t.as(CdsSimpleType.class)).getType());
        }
        return Optional.empty();
    }

    private static String getAnnoValue(CdsElement element, CdsAnnotations annotation) {
        Object value = annotation.getOrDefault((CdsAnnotatable)element);
        if (value != null) {
            if (value instanceof Map) {
                Map m = (Map)value;
                return String.valueOf(m.get("#"));
            }
            return value.toString();
        }
        return null;
    }

    static class CustomAggregate {
        String methodName;
        String unitOrCurrencyRef;

        CustomAggregate(String methodName, String unitOfMeasure) {
            this.methodName = methodName;
            this.unitOrCurrencyRef = unitOfMeasure;
        }

        static CustomAggregate of(String methodName, String uomRef) {
            return new CustomAggregate(methodName, uomRef);
        }

        static CustomAggregate of(String methodName) {
            return CustomAggregate.of(methodName, null);
        }

        String methodName() {
            return this.methodName;
        }

        ElementRef<String> unitOfMeasureRef() {
            return CQL.get((String)this.unitOrCurrencyRef);
        }

        boolean hasUnitOfMeasure() {
            return !StringUtils.isEmpty((CharSequence)this.unitOrCurrencyRef);
        }
    }
}

