/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.processors.response;

import com.sap.cds.Result;
import com.sap.cds.adapter.odata.v4.query.NextLinkInfo;
import com.sap.cds.services.application.ErrorResponseEventContext;
import com.sap.cds.services.messages.Message;
import java.util.List;

public class CdsODataResponse {
    private final int statusCode;
    private final Result result;
    private final NextLinkInfo nextLinkInfo;
    private final String contentType;
    private final String contentDispositionFilename;
    private List<Message> errorMessages;
    private final String contentDispositionType;

    public CdsODataResponse(int statusCode, Result result, NextLinkInfo nextLinkInfo, String contentType, String contentDispositionFilename, String contentDispositionType) {
        this.statusCode = statusCode;
        this.result = result;
        this.nextLinkInfo = nextLinkInfo;
        this.contentType = contentType;
        this.contentDispositionFilename = contentDispositionFilename;
        this.contentDispositionType = contentDispositionType;
    }

    public CdsODataResponse(int statusCode, Result result) {
        this(statusCode, result, null, null, null, null);
    }

    public CdsODataResponse(int statusCode) {
        this(statusCode, null);
    }

    public CdsODataResponse(ErrorResponseEventContext.ErrorResponse errorResponse) {
        this(errorResponse.getHttpStatus());
        this.errorMessages = errorResponse.getMessages();
    }

    public boolean isSuccess() {
        return this.statusCode < 400;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Result getResult() {
        return this.result;
    }

    public NextLinkInfo getNextLinkInfo() {
        return this.nextLinkInfo;
    }

    public List<Message> getErrorMessages() {
        return this.errorMessages;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentDispositionFilename() {
        return this.contentDispositionFilename;
    }

    public String getContentDispositionType() {
        return this.contentDispositionType;
    }
}

