/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.serializer.json.primitive;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.StructTypeHelper;
import com.sap.cds.adapter.odata.v4.serializer.json.api.Data2Json;
import java.io.IOException;
import java.util.function.Function;

public abstract class AbstractPrimitiveData2Json<T, V>
implements Data2Json<T> {
    protected final Function<T, V> valueFunc;

    protected AbstractPrimitiveData2Json(Function<T, V> valueFunc) {
        this.valueFunc = valueFunc;
    }

    @Override
    public void toJson(T data, JsonGenerator json) throws IOException {
        V val = this.valueFunc.apply(data);
        if (val != StructTypeHelper.NOOP) {
            this.write(val, json);
        }
    }

    @Override
    public V getValue(T data) {
        return this.valueFunc.apply(data);
    }

    protected abstract void write(V var1, JsonGenerator var2) throws IOException;
}

