/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.utils;

import com.sap.cds.CdsData;
import com.sap.cds.Row;
import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v4.processors.request.CdsODataRequest;
import com.sap.cds.adapter.odata.v4.utils.ElementUtils;
import com.sap.cds.adapter.odata.v4.utils.mapper.EdmxFlavourMapper;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ETagUtils;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.util.CdsTypeUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmStructuredType;

public class ETagHelper {
    public static boolean isETagHeaderInRequest(CdsODataRequest odataRequest) {
        return odataRequest.getHeader("If-Match") != null || odataRequest.getHeader("If-None-Match") != null;
    }

    public static boolean hasStar(CdsODataRequest request, String header) {
        List headerValueList = ETagUtils.parseHeader((String)request.getHeader(header));
        return headerValueList != null && headerValueList.contains("*");
    }

    public static boolean hasETag(CdsEntity entity) {
        return ETagHelper.getETagElement((CdsStructuredType)entity).map(e -> (String)e.getKey()).isPresent();
    }

    public static String getETagElementName(CdsStructuredType entity) {
        return ETagHelper.getETagElement(entity).map(e -> (String)e.getKey()).orElse(null);
    }

    public static CqnPredicate getETagPredicate(CdsODataRequest request, CdsEntity entity) {
        List<String> ifNoneMatchValues;
        Map.Entry<String, CdsElement> etagElement = ETagHelper.getETagElement((CdsStructuredType)entity).orElseThrow(() -> new IllegalStateException("Entity must have an ETag"));
        Predicate predicate = null;
        List<String> ifMatchValues = ETagHelper.headerValues(request, "If-Match");
        if (ifMatchValues != null && !ifMatchValues.contains("*")) {
            predicate = ETagHelper.etagPredicate(etagElement, ifMatchValues);
        }
        if ((ifNoneMatchValues = ETagHelper.headerValues(request, "If-None-Match")) != null) {
            ifNoneMatchValues.remove("*");
            if (!ifNoneMatchValues.isEmpty()) {
                Predicate predicateIfNone = CQL.not((CqnPredicate)ETagHelper.etagPredicate(etagElement, ifNoneMatchValues));
                predicate = CQL.and((CqnPredicate)predicate, (CqnPredicate)predicateIfNone);
            }
        }
        return predicate;
    }

    private static Predicate etagPredicate(Map.Entry<String, CdsElement> etagElement, List<String> values) {
        return CQL.eTag((CqnElementRef)CQL.get((String)etagElement.getKey()), (Object)CQL.list(values.stream().map(v -> ETagHelper.convertETag(v, (CdsElement)etagElement.getValue())).toList()));
    }

    private static List<String> headerValues(CdsODataRequest r, String h) {
        return ETagUtils.parseHeader((String)r.getHeader(h));
    }

    private static Optional<Map.Entry<String, CdsElement>> getETagElement(CdsStructuredType entity) {
        return ElementUtils.recursiveElements(entity, e -> CdsAnnotations.ETAG.isTrue((CdsAnnotatable)e)).entrySet().stream().findFirst();
    }

    private static CqnValue convertETag(String value, CdsElement element) {
        CdsBaseType type = ((CdsSimpleType)element.getType().as(CdsSimpleType.class)).getType();
        try {
            return CQL.val((Object)CdsTypeUtils.parse((CdsBaseType)type, (String)value));
        }
        catch (CdsDataException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_VALUE_INVALID, new Object[]{type.cdsName(), e});
        }
    }

    public static String getETagProperty(CdsRequestGlobals globals, EdmStructuredType entityType) {
        String eTagElement;
        String edmEntityName = entityType.getFullQualifiedName().getFullQualifiedNameAsString();
        String cdsEntityName = globals.getCdsEntityNames().getOrDefault(edmEntityName, edmEntityName);
        Optional cdsEntity = globals.getModel().findEntity(cdsEntityName);
        if (cdsEntity.isPresent() && (eTagElement = ETagHelper.getETagElementName((CdsStructuredType)cdsEntity.get())) != null) {
            return EdmxFlavourMapper.create(globals.getEdmxFlavour(), false).remap(eTagElement, (CdsStructuredType)cdsEntity.get());
        }
        return null;
    }

    public static String getEtagValue(CdsRequestGlobals globals, EdmEntityType entityType, Row row) {
        String eTagProperty = ETagHelper.getETagProperty(globals, (EdmStructuredType)entityType);
        if (null != eTagProperty) {
            return ETagHelper.getEtagValue((Map<String, Object>)row, eTagProperty);
        }
        return null;
    }

    public static String getEtagValue(Map<String, Object> row, String eTagProperty) {
        Object value;
        if (row instanceof CdsData) {
            CdsData d = (CdsData)row;
            v0 = d.getMetadata("etag");
        } else {
            v0 = value = null;
        }
        if (value == null) {
            value = row.get(eTagProperty);
        }
        return value != null ? ETagUtils.createETagHeaderValue((String)value.toString()) : null;
    }
}

