/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.metadata.cds;

import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsOperation;
import com.sap.cds.reflect.CdsParameter;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.ODataUtils;
import java.util.function.Function;
import org.apache.olingo.commons.api.edm.FullQualifiedName;

class CdsServiceEdmUtils {
    public static final String CDS_MAP_TYPE = "cds_Map";

    private CdsServiceEdmUtils() {
    }

    static FullQualifiedName fqn(CdsDefinition def) {
        return new FullQualifiedName(def.getQualifier(), CdsServiceEdmUtils.name(def));
    }

    static FullQualifiedName structuredTypeFqn(CdsService service, CdsStructuredType type, Function<CdsStructuredType, String> anonymousNameSupplier) {
        if (type.isAnonymous()) {
            return new FullQualifiedName(service.getQualifiedName(), anonymousNameSupplier.apply(type));
        }
        if (!type.getQualifier().equals(service.getQualifiedName())) {
            return new FullQualifiedName(service.getQualifiedName(), ODataUtils.toODataName((String)type.getQualifiedName()));
        }
        return CdsServiceEdmUtils.fqn((CdsDefinition)type);
    }

    static String name(CdsDefinition def) {
        return ODataUtils.toODataName((String)def.getName());
    }

    static String nameElement(CdsDefinition def, String parentName, String elementName) {
        return parentName + "_" + elementName;
    }

    static String nameParameter(CdsDefinition def, CdsOperation operation, CdsParameter parameter) {
        return "param_" + ODataUtils.toODataName((String)operation.getQualifiedName()) + "_" + parameter.getName();
    }

    static String nameReturn(CdsDefinition def, CdsOperation operation) {
        return "return_" + ODataUtils.toODataName((String)operation.getQualifiedName());
    }

    static CdsEntity target(CdsStructuredType entity, CdsElement element) {
        if (element.getName().equals("SiblingEntity")) {
            return (CdsEntity)entity;
        }
        return ((CdsAssociationType)element.getType().as(CdsAssociationType.class)).getTarget();
    }

    static boolean isParameterized(CdsEntity entity) {
        return entity.params().count() > 0L;
    }

    static boolean isIncluded(CdsEntity entity) {
        return !DraftUtils.isDraftEnabled((CdsAnnotatable)entity) || !entity.getName().endsWith("_drafts");
    }

    static boolean isIncluded(CdsElement element) {
        return (Boolean)element.getAnnotationValue("cds.api.ignore", (Object)false) == false && !element.getName().equals("DraftAdministrativeData_DraftUUID");
    }

    static boolean isIncludedEntitySet(CdsEntity entity) {
        return CdsServiceEdmUtils.isIncluded(entity) && !entity.getName().equals("DraftAdministrativeData");
    }

    static boolean isIncludedEntitySetAssociation(CdsElement element) {
        return element.getType().isAssociation() && !element.getName().equals("DraftAdministrativeData");
    }
}

