/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.metadata.provider;

import com.sap.cds.adapter.edmx.EdmxV4Provider;
import com.sap.cds.adapter.edmx.EdmxX4Provider;
import com.sap.cds.adapter.odata.v4.metadata.provider.AbstractDefaultEdmxProvider;
import com.sap.cds.adapter.odata.v4.metadata.provider.AbstractDynamicEdmxProvider;
import com.sap.cds.adapter.odata.v4.metadata.provider.DefaultEdmxI18nProvider;
import com.sap.cds.adapter.odata.v4.metadata.provider.DynamicEdmxI18nProvider;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.runtime.CdsProvider;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.utils.model.DynamicModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdmxProviderConfiguration
implements CdsRuntimeConfiguration {
    private static Logger logger = LoggerFactory.getLogger(EdmxProviderConfiguration.class);

    public void providers(CdsRuntimeConfigurer configurer) {
        DynamicModelUtils utils = new DynamicModelUtils(configurer.getCdsRuntime());
        CdsProperties properties = configurer.getCdsRuntime().getEnvironment().getCdsProperties();
        if (properties.getOdataV4().getEndpoint().isEnabled().booleanValue()) {
            DefaultEdmxV4Provider defaultV4Provider = new DefaultEdmxV4Provider(configurer.getCdsRuntime());
            configurer.provider((CdsProvider)defaultV4Provider);
            if (utils.isModelProviderEnabled()) {
                configurer.provider((CdsProvider)new DynamicEdmxV4Provider(configurer.getCdsRuntime(), utils, defaultV4Provider));
                logger.info("Initialized Dynamic EDMX V4 Provider");
            } else {
                logger.info("Initialized Default EDMX V4 Provider");
            }
        }
        if (properties.getOdataX4().getEndpoint().isEnabled().booleanValue()) {
            DefaultEdmxX4Provider defaultX4Provider = new DefaultEdmxX4Provider(configurer.getCdsRuntime());
            configurer.provider((CdsProvider)defaultX4Provider);
            if (utils.isModelProviderEnabled()) {
                configurer.provider((CdsProvider)new DynamicEdmxX4Provider(configurer.getCdsRuntime(), utils, defaultX4Provider));
                logger.info("Initialized Dynamic EDMX X4 Provider");
            } else {
                logger.info("Initialized Default EDMX X4 Provider");
            }
        }
        if (properties.getOdataV4().getLazyI18n().isEnabled().booleanValue()) {
            DefaultEdmxI18nProvider defaultI18nProvider = DefaultEdmxI18nProvider.create();
            configurer.provider((CdsProvider)defaultI18nProvider);
            if (utils.isModelProviderEnabled()) {
                configurer.provider((CdsProvider)new DynamicEdmxI18nProvider(configurer.getCdsRuntime(), utils, defaultI18nProvider));
                logger.info("Initialized Dynamic EDMX I18n Provider");
            } else {
                logger.info("Initialized Default EDMX I18n Provider");
            }
        }
    }

    public int order() {
        return Integer.MIN_VALUE;
    }

    private static class DefaultEdmxV4Provider
    extends AbstractDefaultEdmxProvider
    implements EdmxV4Provider {
        private static final String UNLOCALIZED_BASE_PATH = "edmx/odata/v4";

        public DefaultEdmxV4Provider(CdsRuntime runtime) {
            super(runtime, DefaultEdmxV4Provider.determineBasePath(runtime));
        }

        private static String determineBasePath(CdsRuntime runtime) {
            CdsProperties.ODataV4 config = runtime.getEnvironment().getCdsProperties().getOdataV4();
            if (EdmxProviderConfiguration.class.getClassLoader().getResource(config.getEdmxPath()) != null) {
                return config.getEdmxPath();
            }
            if (config.getLazyI18n().isEnabled().booleanValue() && EdmxProviderConfiguration.class.getClassLoader().getResource(UNLOCALIZED_BASE_PATH) != null) {
                return UNLOCALIZED_BASE_PATH;
            }
            return "edmx";
        }
    }

    private static class DynamicEdmxV4Provider
    extends AbstractDynamicEdmxProvider
    implements EdmxV4Provider {
        public DynamicEdmxV4Provider(CdsRuntime runtime, DynamicModelUtils utils, DefaultEdmxV4Provider previous) {
            super("v4", runtime, utils, previous);
        }
    }

    private static class DefaultEdmxX4Provider
    extends AbstractDefaultEdmxProvider
    implements EdmxX4Provider {
        public DefaultEdmxX4Provider(CdsRuntime runtime) {
            super(runtime, runtime.getEnvironment().getCdsProperties().getOdataX4().getEdmxPath());
        }
    }

    private static class DynamicEdmxX4Provider
    extends AbstractDynamicEdmxProvider
    implements EdmxX4Provider {
        public DynamicEdmxX4Provider(CdsRuntime runtime, DynamicModelUtils utils, DefaultEdmxX4Provider previous) {
            super("x4", runtime, utils, previous);
        }
    }
}

