/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.services.messages.Message;
import com.sap.cds.services.messages.MessageTarget;
import com.sap.cds.services.messages.Messages;
import com.sap.cds.services.utils.ODataUtils;
import com.sap.cds.services.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagesUtils {
    private static final Logger logger = LoggerFactory.getLogger(MessagesUtils.class);
    private static final String CODE = "code";
    private static final String MESSAGE = "message";
    private static final String NUMERIC_SEVERITY = "numericSeverity";
    private static final String TARGET = "target";
    private static final String LONG_TEXT_URL = "longtextUrl";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSapMessagesHeader(String bindingParameter, Messages messages) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        JsonFactoryBuilder builder = new JsonFactoryBuilder().configure(JsonWriteFeature.ESCAPE_NON_ASCII, true);
        try (JsonGenerator json = new JsonFactory(builder).createGenerator((OutputStream)outputStream);){
            boolean isFirst = true;
            Iterator iterator = messages.stream().iterator();
            while (iterator.hasNext()) {
                String[] stringifiedTargets;
                if (isFirst) {
                    json.writeStartArray();
                    isFirst = false;
                }
                Message message = (Message)iterator.next();
                json.writeStartObject();
                json.writeStringField(CODE, MessagesUtils.getMessageCode(message));
                json.writeStringField(MESSAGE, message.getMessage());
                json.writeNumberField(NUMERIC_SEVERITY, message.getSeverity().getNumericSeverity());
                String target = MessagesUtils.getTarget(bindingParameter, message.getTarget(), true);
                if (target != null) {
                    json.writeStringField(TARGET, target);
                }
                if ((stringifiedTargets = (String[])message.getAdditionalTargets().stream().map(t -> MessagesUtils.getTarget(bindingParameter, t, true)).filter(Objects::nonNull).toArray(String[]::new)).length > 0) {
                    json.writeFieldName("additionalTargets");
                    json.writeArray(stringifiedTargets, 0, stringifiedTargets.length);
                }
                if (!StringUtils.isEmpty((String)message.getLongTextUrl())) {
                    json.writeStringField(LONG_TEXT_URL, message.getLongTextUrl());
                }
                json.writeEndObject();
            }
            if (!isFirst) {
                json.writeEndArray();
            }
            json.close();
            if (outputStream.size() == 0) return null;
            String string = outputStream.toString("UTF-8");
            return string;
        }
        catch (IOException e) {
            logger.error("Failed to create sap messages header", (Throwable)e);
        }
        return null;
    }

    public static String getMessageCode(Message message) {
        return StringUtils.isEmpty((String)message.getCode()) ? "<none>" : message.getCode();
    }

    public static String getTarget(String bindingParameter, MessageTarget messageTarget, boolean applyParameterPrefix) {
        if (messageTarget == null) {
            return null;
        }
        return ODataUtils.toODataTarget((String)bindingParameter, (String)messageTarget.getParameter(), (CqnReference)messageTarget.getRef(), (boolean)false, (boolean)applyParameterPrefix);
    }
}

