/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.processors.response;

import com.sap.cds.Result;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmKeyPropertyRef;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.core.Encoder;
import org.apache.olingo.commons.core.edm.primitivetype.AbstractGeospatialType;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDateTimeOffset;
import org.apache.olingo.commons.core.edm.primitivetype.EdmString;
import org.apache.olingo.commons.core.edm.primitivetype.EdmTimeOfDay;

public class ResultSetProcessor {
    public static String getEntityId(EdmEntityType type, Map<?, ?> row) {
        StringBuilder result = new StringBuilder();
        List keyNames = type.getKeyPredicateNames();
        boolean first = true;
        for (String keyName : keyNames) {
            EdmType propertyType;
            EdmKeyPropertyRef keyRef = type.getKeyPropertyRef(keyName);
            if (first) {
                result.append('(');
                first = false;
            } else {
                result.append(',');
            }
            if (keyNames.size() > 1) {
                result.append(Encoder.encode((String)keyName)).append('=');
            }
            String keyValue = (propertyType = keyRef.getProperty().getType()) instanceof EdmString || propertyType instanceof EdmDateTimeOffset || propertyType instanceof EdmTimeOfDay || propertyType instanceof AbstractGeospatialType ? Encoder.encode((String)String.valueOf(row.get(keyName))) : String.valueOf(row.get(keyName));
            if (propertyType instanceof EdmString) {
                result.append("'").append(keyValue).append("'");
                continue;
            }
            result.append(keyValue);
        }
        if (result.length() > 0) {
            result.append(')');
        }
        return result.toString();
    }

    public static int toCount(Result result) {
        int count = 0;
        for (Map row : result.list()) {
            count += Integer.parseInt(Optional.ofNullable(row.get("count")).orElseThrow(() -> new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MISSING_VALUE_FOR_COUNT, new Object[0])).toString());
        }
        return count;
    }
}

