/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.CdsData;
import com.sap.cds.Result;
import com.sap.cds.Row;
import com.sap.cds.adapter.odata.v4.query.LimitLookup;
import com.sap.cds.adapter.odata.v4.query.NextLinkInfo;
import com.sap.cds.ql.BooleanValue;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Literal;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.TenantAwareCache;
import com.sap.cds.util.CdsTypeUtils;
import com.sap.cds.util.transformations.LimitCalculator;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.server.api.uri.UriInfo;

public final class QueryLimitUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String VALUE = "v";
    private static final String KEY = "k";
    private static final String HAS_ASCENDING_ORDER = "a";
    private static final String ALREADY_READ = "r";
    private static final String TOKEN_CONTENT = "c";
    private static TenantAwareCache<LimitLookup, CdsModel> limitLookup;
    private final CdsEntity entity;
    private final boolean isReliablePaging;
    private int top;
    private int skip;
    private boolean serverDrivenPaging;
    private int alreadyRead;
    private List<Map<String, Object>> sortedValues;

    public static void initialize(CdsRuntime runtime) {
        CdsProperties.Query.Limit config = runtime.getEnvironment().getCdsProperties().getQuery().getLimit();
        limitLookup = TenantAwareCache.create(() -> new LimitLookup(config), (CdsRuntime)runtime);
    }

    public QueryLimitUtils(CdsService service, CdsEntity entity, UriInfo uriInfo, CdsProperties.Query.Limit properties) {
        this.entity = entity;
        this.isReliablePaging = properties.getReliablePaging().isEnabled();
        this.initializeLimits(uriInfo, service, entity);
    }

    public void handlePagination(List<Select<?>> selects) {
        if (this.top < Integer.MAX_VALUE || this.skip > 0) {
            for (Select<?> select : selects) {
                LimitCalculator calc = LimitCalculator.of(select);
                calc.skip((long)this.skip);
                calc.top((long)this.top);
                select.limit(calc.top(), calc.skip());
            }
        }
        if (selects.size() == 1 && this.sortedValues != null && !this.sortedValues.isEmpty()) {
            boolean allAscending;
            CqnPredicate result = this.sortedValues.size() == 1 ? QueryLimitUtils.comparison(this.sortedValues.get(0)) : ((allAscending = this.sortedValues.stream().allMatch(sv -> Boolean.TRUE.equals(sv.get(HAS_ASCENDING_ORDER)))) ? this.rowValueComparison() : this.mixedComparison());
            SelectBuilder select = (SelectBuilder)selects.get(0);
            select.filter(result);
        }
    }

    private CqnPredicate mixedComparison() {
        BooleanValue result = CQL.FALSE;
        Map<String, Object> previous = null;
        for (Map<String, Object> entry : this.sortedValues) {
            CqnPredicate next = QueryLimitUtils.comparison(entry);
            if (previous != null) {
                String previousElementName = (String)previous.get(KEY);
                Object previousValue = previous.get(VALUE);
                next = CQL.get((String)previousElementName).eq(previousValue).and(next, new CqnPredicate[0]);
            }
            previous = entry;
            result = result.or(next, new CqnPredicate[0]);
        }
        return result;
    }

    private static CqnPredicate comparison(Map<String, Object> sv) {
        ElementRef ref = CQL.get((String)((String)sv.get(KEY)));
        Object value = sv.get(VALUE);
        boolean asc = (Boolean)sv.get(HAS_ASCENDING_ORDER);
        return asc ? ref.gt(value) : ref.lt(value);
    }

    private CqnPredicate rowValueComparison() {
        int n = this.sortedValues.size();
        ArrayList refs = new ArrayList(n);
        ArrayList vals = new ArrayList(n);
        this.sortedValues.forEach(sv -> {
            ElementRef ref = CQL.get((String)((String)sv.get(KEY)));
            Literal val = CQL.val(sv.get(VALUE));
            refs.add(ref);
            vals.add(val);
        });
        return CQL.comparison((CqnValue)CQL.list(refs), (CqnComparisonPredicate.Operator)CqnComparisonPredicate.Operator.GT, (CqnValue)CQL.list(vals));
    }

    public NextLinkInfo generateNextLink(Result result, CqnSelect select) {
        if (result.rowCount() >= (long)this.top && this.serverDrivenPaging) {
            int nextAlreadyRead = this.alreadyRead + (int)result.rowCount();
            if (this.isReliablePaging && result.rowCount() > 0L && select != null) {
                Row row = (Row)result.list().get((int)result.rowCount() - 1);
                ArrayList values = new ArrayList();
                for (CqnSortSpecification spec : select.orderBy()) {
                    String key;
                    if (!spec.value().isRef() || this.getValidElement(key = spec.value().asRef().displayName()) == null || !row.containsKey((Object)key)) continue;
                    HashMap<String, Object> value = new HashMap<String, Object>();
                    value.put(HAS_ASCENDING_ORDER, CqnSortSpecification.Order.ASC == spec.order());
                    value.put(KEY, key);
                    value.put(VALUE, row.get((Object)key));
                    values.add(value);
                }
                if (values.size() == select.orderBy().size()) {
                    CdsData tokenMap = CdsData.create();
                    tokenMap.put((Object)ALREADY_READ, (Object)nextAlreadyRead);
                    tokenMap.put((Object)TOKEN_CONTENT, values);
                    String skipToken = Base64.getEncoder().encodeToString(tokenMap.toJson().getBytes(StandardCharsets.UTF_8));
                    return new NextLinkInfo(skipToken);
                }
            }
            return new NextLinkInfo(String.valueOf(nextAlreadyRead));
        }
        return null;
    }

    private void initializeLimits(UriInfo uriInfo, CdsService service, CdsEntity entity) {
        int maxTop;
        int defaultTop;
        this.serverDrivenPaging = false;
        this.top = Integer.MAX_VALUE;
        this.skip = 0;
        if (uriInfo.getTopOption() != null) {
            this.top = uriInfo.getTopOption().getValue();
        }
        if (uriInfo.getSkipOption() != null) {
            this.skip = uriInfo.getSkipOption().getValue();
        }
        if (uriInfo.getSkipTokenOption() != null) {
            this.initializeSkipToken(uriInfo.getSkipTokenOption().getValue());
            this.skip = this.sortedValues == null ? (this.skip += this.alreadyRead) : 0;
            if (this.top != Integer.MAX_VALUE) {
                this.top = Math.max(this.top - this.alreadyRead, 0);
            }
        }
        if ((defaultTop = ((LimitLookup)limitLookup.findOrCreate()).getDefaultValue(service, entity)) > 0 && this.top == Integer.MAX_VALUE) {
            this.top = defaultTop;
            this.serverDrivenPaging = true;
        }
        if ((maxTop = ((LimitLookup)limitLookup.findOrCreate()).getMaxValue(service, entity)) > 0 && this.top > maxTop) {
            this.top = maxTop;
            this.serverDrivenPaging = true;
        }
    }

    private void initializeSkipToken(String skipToken) {
        try {
            if (StringUtils.isNumeric((CharSequence)skipToken)) {
                this.alreadyRead = Integer.parseInt(skipToken);
            } else if (this.isReliablePaging) {
                TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
                Map token = (Map)objectMapper.readValue(Base64.getDecoder().decode(skipToken), (TypeReference)typeRef);
                this.alreadyRead = (Integer)token.get(ALREADY_READ);
                this.sortedValues = (List)token.get(TOKEN_CONTENT);
                for (Map<String, Object> sortedValue : this.sortedValues) {
                    String elementName = (String)sortedValue.get(KEY);
                    Object value = sortedValue.get(VALUE);
                    Object converted = this.convert(elementName, value);
                    sortedValue.put(VALUE, converted);
                }
            }
        }
        catch (Exception e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MALFORMED_SKIPTOKEN, new Object[]{e});
        }
    }

    private Object convert(String elementName, Object value) {
        CdsElement element = this.getValidElement(elementName);
        if (element != null) {
            try {
                String stringValue = value == null ? null : value.toString();
                return CdsTypeUtils.parse((CdsBaseType)((CdsSimpleType)element.getType().as(CdsSimpleType.class)).getType(), (String)stringValue);
            }
            catch (CdsDataException e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MALFORMED_SKIPTOKEN, new Object[]{e});
            }
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MALFORMED_SKIPTOKEN, new Object[0]);
    }

    private CdsElement getValidElement(String elementName) {
        return this.entity.findElement(elementName).filter(e -> e.getType().isSimple() && !e.isVirtual()).orElse(null);
    }
}

