/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.config.pojo;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class CdsProperties {
    private Environment environment = new Environment();
    private DataSource dataSource = new DataSource();
    private Model model = new Model();
    private Security security = new Security();
    private ODataV4 odataV4 = new ODataV4();
    private ODataV2 odataV2 = new ODataV2();
    private Messaging messaging = new Messaging();
    private MultiTenancy multiTenancy = new MultiTenancy();
    private Application application = new Application();
    private Locales locales = new Locales();
    private Errors errors = new Errors();
    private Drafts drafts = new Drafts();
    private Query query = new Query();

    @Deprecated
    public Map<String, Application.ApplicationServiceConfig> getServices() {
        return this.getApplication().getServices();
    }

    @Deprecated
    public void setServices(Map<String, Application.ApplicationServiceConfig> services) {
        this.getApplication().setServices(services);
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Model getModel() {
        return this.model;
    }

    public Security getSecurity() {
        return this.security;
    }

    public ODataV4 getOdataV4() {
        return this.odataV4;
    }

    public ODataV2 getOdataV2() {
        return this.odataV2;
    }

    public Messaging getMessaging() {
        return this.messaging;
    }

    public MultiTenancy getMultiTenancy() {
        return this.multiTenancy;
    }

    public Application getApplication() {
        return this.application;
    }

    public Locales getLocales() {
        return this.locales;
    }

    public Errors getErrors() {
        return this.errors;
    }

    public Drafts getDrafts() {
        return this.drafts;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public void setSecurity(Security security) {
        this.security = security;
    }

    public void setOdataV4(ODataV4 odataV4) {
        this.odataV4 = odataV4;
    }

    public void setOdataV2(ODataV2 odataV2) {
        this.odataV2 = odataV2;
    }

    public void setMessaging(Messaging messaging) {
        this.messaging = messaging;
    }

    public void setMultiTenancy(MultiTenancy multiTenancy) {
        this.multiTenancy = multiTenancy;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public void setLocales(Locales locales) {
        this.locales = locales;
    }

    public void setErrors(Errors errors) {
        this.errors = errors;
    }

    public void setDrafts(Drafts drafts) {
        this.drafts = drafts;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public static class Definition {
        protected String name;
        protected Messaging messaging = new Messaging();
        protected Map<String, Definition> definitions = new HashMap<String, Definition>();

        public Definition getDefinition(String name) {
            return this.definitions.values().stream().filter(d -> Objects.equals(d.getName(), name)).findFirst().orElse(new Definition());
        }

        public String getName() {
            return this.name;
        }

        public Messaging getMessaging() {
            return this.messaging;
        }

        public Map<String, Definition> getDefinitions() {
            return this.definitions;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setMessaging(Messaging messaging) {
            this.messaging = messaging;
        }

        public void setDefinitions(Map<String, Definition> definitions) {
            this.definitions = definitions;
        }

        public static class Messaging
        extends Enabled {
            private List<String> services = new ArrayList<String>();
            private List<String> topics = new ArrayList<String>();

            public Messaging() {
                super(null);
            }

            public List<String> getServices() {
                return this.services;
            }

            public List<String> getTopics() {
                return this.topics;
            }

            public void setServices(List<String> services) {
                this.services = services;
            }

            public void setTopics(List<String> topics) {
                this.topics = topics;
            }
        }
    }

    public static class Servlet
    extends Enabled {
        private String path;

        public Servlet(String defaultPath) {
            super(true);
            this.path = defaultPath;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }

    public static class Enabled {
        private Boolean enabled;

        public Enabled(Boolean byDefault) {
            this.enabled = byDefault;
        }

        public Boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class Query {
        private Limit limit = new Limit();
        private Enabled implicitSorting = new Enabled(true);

        public Limit getLimit() {
            return this.limit;
        }

        public Enabled getImplicitSorting() {
            return this.implicitSorting;
        }

        public void setLimit(Limit limit) {
            this.limit = limit;
        }

        public void setImplicitSorting(Enabled implicitSorting) {
            this.implicitSorting = implicitSorting;
        }

        public static class Limit {
            private int _default = 0;
            private int max = 1000;

            public int getDefault() {
                return this._default;
            }

            public void setDefault(int _default) {
                this._default = _default;
            }

            public int getMax() {
                return this.max;
            }

            public void setMax(int max) {
                this.max = max;
            }
        }
    }

    public static class Drafts {
        private Duration cancellationTimeout = Duration.ofMinutes(15L);
        private Enabled associationsToInactiveEntities = new Enabled(true);
        private Duration deletionTimeout = Duration.ofDays(30L);
        private GC gc = new GC();

        public Duration getCancellationTimeout() {
            return this.cancellationTimeout;
        }

        public Enabled getAssociationsToInactiveEntities() {
            return this.associationsToInactiveEntities;
        }

        public Duration getDeletionTimeout() {
            return this.deletionTimeout;
        }

        public GC getGc() {
            return this.gc;
        }

        public void setCancellationTimeout(Duration cancellationTimeout) {
            this.cancellationTimeout = cancellationTimeout;
        }

        public void setAssociationsToInactiveEntities(Enabled associationsToInactiveEntities) {
            this.associationsToInactiveEntities = associationsToInactiveEntities;
        }

        public void setDeletionTimeout(Duration deletionTimeout) {
            this.deletionTimeout = deletionTimeout;
        }

        public void setGc(GC gc) {
            this.gc = gc;
        }

        public static class GC
        extends Enabled {
            private Duration interval = Duration.ofHours(6L);

            public GC() {
                super(true);
            }

            public Duration getInterval() {
                return this.interval;
            }

            public void setInterval(Duration interval) {
                this.interval = interval;
            }
        }
    }

    public static class Errors {
        private Enabled stackMessages = new Enabled(true);
        private boolean extended = false;

        public Enabled getStackMessages() {
            return this.stackMessages;
        }

        public boolean isExtended() {
            return this.extended;
        }

        public void setStackMessages(Enabled stackMessages) {
            this.stackMessages = stackMessages;
        }

        public void setExtended(boolean extended) {
            this.extended = extended;
        }
    }

    public static class Locales {
        private Normalization normalization = new Normalization();

        public Normalization getNormalization() {
            return this.normalization;
        }

        public void setNormalization(Normalization normalization) {
            this.normalization = normalization;
        }

        public static class Normalization {
            private boolean defaults = true;
            private List<String> includeList = new ArrayList<String>();

            @Deprecated
            public List<String> getWhiteList() {
                return this.getIncludeList();
            }

            @Deprecated
            public void setWhiteList(List<String> whiteList) {
                this.setIncludeList(whiteList);
            }

            public boolean isDefaults() {
                return this.defaults;
            }

            public List<String> getIncludeList() {
                return this.includeList;
            }

            public void setDefaults(boolean defaults) {
                this.defaults = defaults;
            }

            public void setIncludeList(List<String> includeList) {
                this.includeList = includeList;
            }
        }
    }

    public static class Application {
        private Map<String, ApplicationServiceConfig> services = new HashMap<String, ApplicationServiceConfig>();

        public ApplicationServiceConfig getService(String name) {
            return this.services.values().stream().filter(s -> Objects.equals(s.getName(), name)).findFirst().orElse(new ApplicationServiceConfig(name));
        }

        public List<ApplicationServiceConfig> getServicesByModel(String model) {
            return this.services.values().stream().filter(s -> Objects.equals(s.getModel(), model) || s.getModel() == null && Objects.equals(s.getName(), model)).collect(Collectors.toList());
        }

        public Map<String, ApplicationServiceConfig> getServices() {
            return this.services;
        }

        public void setServices(Map<String, ApplicationServiceConfig> services) {
            this.services = services;
        }

        public static class ApplicationServiceConfig
        extends Definition {
            private String model;
            private String source;
            private Serve serve = new Serve();
            private Destination destination = new Destination();
            private Messaging messaging = new Messaging();

            public ApplicationServiceConfig() {
            }

            public ApplicationServiceConfig(String name) {
                this.name = name;
            }

            public String getModel() {
                return this.model;
            }

            public String getSource() {
                return this.source;
            }

            public Serve getServe() {
                return this.serve;
            }

            public Destination getDestination() {
                return this.destination;
            }

            @Override
            public Messaging getMessaging() {
                return this.messaging;
            }

            public void setModel(String model) {
                this.model = model;
            }

            public void setSource(String source) {
                this.source = source;
            }

            public void setServe(Serve serve) {
                this.serve = serve;
            }

            public void setDestination(Destination destination) {
                this.destination = destination;
            }

            public void setMessaging(Messaging messaging) {
                this.messaging = messaging;
            }

            public static class Messaging
            extends Definition.Messaging {
                private String type;
                private String topicNamespace;

                public String getType() {
                    return this.type;
                }

                public String getTopicNamespace() {
                    return this.topicNamespace;
                }

                public void setType(String type) {
                    this.type = type;
                }

                public void setTopicNamespace(String topicNamespace) {
                    this.topicNamespace = topicNamespace;
                }
            }

            public static class Destination {
                public static final String ODATA_V2_TYPE = "odata-v2";
                public static final String ODATA_V4_TYPE = "odata-v4";
                private String type = "odata-v4";
                private String name;
                private String suffix;
                private String service;

                public String getType() {
                    return this.type;
                }

                public String getName() {
                    return this.name;
                }

                public String getSuffix() {
                    return this.suffix;
                }

                public String getService() {
                    return this.service;
                }

                public void setType(String type) {
                    this.type = type;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public void setSuffix(String suffix) {
                    this.suffix = suffix;
                }

                public void setService(String service) {
                    this.service = service;
                }
            }

            public static class Serve {
                private boolean ignore;

                public boolean isIgnore() {
                    return this.ignore;
                }

                public void setIgnore(boolean ignore) {
                    this.ignore = ignore;
                }
            }
        }
    }

    public static class MultiTenancy {
        private String callbackUrl;
        private Servlet endpoint = new Servlet("/mt/v1.0/subscriptions");
        private DataSource dataSource = new DataSource();
        private ServiceManager serviceManager = new ServiceManager();
        private Security security = new Security();
        private Deployer deployer = new Deployer();
        private Sidecar sidecar = new Sidecar();
        private AppUi appUi = new AppUi();
        private HealthCheck healthCheck = new HealthCheck();

        @Deprecated
        public ServiceManager getInstanceManager() {
            return this.serviceManager;
        }

        @Deprecated
        public void setInstanceManager(ServiceManager serviceManager) {
            this.serviceManager = serviceManager;
        }

        public String getCallbackUrl() {
            return this.callbackUrl;
        }

        public Servlet getEndpoint() {
            return this.endpoint;
        }

        public DataSource getDataSource() {
            return this.dataSource;
        }

        public ServiceManager getServiceManager() {
            return this.serviceManager;
        }

        public Security getSecurity() {
            return this.security;
        }

        public Deployer getDeployer() {
            return this.deployer;
        }

        public Sidecar getSidecar() {
            return this.sidecar;
        }

        public AppUi getAppUi() {
            return this.appUi;
        }

        public HealthCheck getHealthCheck() {
            return this.healthCheck;
        }

        public void setCallbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
        }

        public void setEndpoint(Servlet endpoint) {
            this.endpoint = endpoint;
        }

        public void setDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public void setServiceManager(ServiceManager serviceManager) {
            this.serviceManager = serviceManager;
        }

        public void setSecurity(Security security) {
            this.security = security;
        }

        public void setDeployer(Deployer deployer) {
            this.deployer = deployer;
        }

        public void setSidecar(Sidecar sidecar) {
            this.sidecar = sidecar;
        }

        public void setAppUi(AppUi appUi) {
            this.appUi = appUi;
        }

        public void setHealthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
        }

        public static class HealthCheck
        extends Enabled {
            private String healthCheckStatement = "";
            private long intervalMillis = 10000L;

            public HealthCheck() {
                super(true);
            }

            public String getHealthCheckStatement() {
                return this.healthCheckStatement;
            }

            public long getIntervalMillis() {
                return this.intervalMillis;
            }

            public void setHealthCheckStatement(String healthCheckStatement) {
                this.healthCheckStatement = healthCheckStatement;
            }

            public void setIntervalMillis(long intervalMillis) {
                this.intervalMillis = intervalMillis;
            }
        }

        public static class AppUi {
            private String url;
            private String tenantSeparator;

            public String getUrl() {
                return this.url;
            }

            public String getTenantSeparator() {
                return this.tenantSeparator;
            }

            public void setUrl(String url) {
                this.url = url;
            }

            public void setTenantSeparator(String tenantSeparator) {
                this.tenantSeparator = tenantSeparator;
            }
        }

        public static class Sidecar {
            private Cache cache = new Cache();
            private String url;
            private boolean reuseToken = false;

            public Cache getCache() {
                return this.cache;
            }

            public String getUrl() {
                return this.url;
            }

            public boolean isReuseToken() {
                return this.reuseToken;
            }

            public void setCache(Cache cache) {
                this.cache = cache;
            }

            public void setUrl(String url) {
                this.url = url;
            }

            public void setReuseToken(boolean reuseToken) {
                this.reuseToken = reuseToken;
            }

            public static class Cache {
                private int maxSize = 20;
                private int expirationTime = 600;
                private int refreshTime = 60;

                public int getMaxSize() {
                    return this.maxSize;
                }

                public int getExpirationTime() {
                    return this.expirationTime;
                }

                public int getRefreshTime() {
                    return this.refreshTime;
                }

                public void setMaxSize(int maxSize) {
                    this.maxSize = maxSize;
                }

                public void setExpirationTime(int expirationTime) {
                    this.expirationTime = expirationTime;
                }

                public void setRefreshTime(int refreshTime) {
                    this.refreshTime = refreshTime;
                }
            }
        }

        public static class Deployer {
            private String url;
            private String user;
            private String password;
            private Duration asyncTimeout = Duration.ofMinutes(10L);

            public String getUrl() {
                return this.url;
            }

            public String getUser() {
                return this.user;
            }

            public String getPassword() {
                return this.password;
            }

            public Duration getAsyncTimeout() {
                return this.asyncTimeout;
            }

            public void setUrl(String url) {
                this.url = url;
            }

            public void setUser(String user) {
                this.user = user;
            }

            public void setPassword(String password) {
                this.password = password;
            }

            public void setAsyncTimeout(Duration asyncTimeout) {
                this.asyncTimeout = asyncTimeout;
            }
        }

        public static class Security {
            private String subscriptionScope = "mtcallback";
            private String deploymentScope = "mtdeployment";

            public String getSubscriptionScope() {
                return this.subscriptionScope;
            }

            public String getDeploymentScope() {
                return this.deploymentScope;
            }

            public void setSubscriptionScope(String subscriptionScope) {
                this.subscriptionScope = subscriptionScope;
            }

            public void setDeploymentScope(String deploymentScope) {
                this.deploymentScope = deploymentScope;
            }
        }

        public static class ServiceManager {
            private int timeout = 3600;

            public int getTimeout() {
                return this.timeout;
            }

            public void setTimeout(int timeout) {
                this.timeout = timeout;
            }
        }

        public static class DataSource {
            private String pool = "hikari";
            private Enabled combinePools = new Enabled(false);
            private List<String> hanaDatabaseIds = new ArrayList<String>();

            public String getPool() {
                return this.pool;
            }

            public Enabled getCombinePools() {
                return this.combinePools;
            }

            public List<String> getHanaDatabaseIds() {
                return this.hanaDatabaseIds;
            }

            public void setPool(String pool) {
                this.pool = pool;
            }

            public void setCombinePools(Enabled combinePools) {
                this.combinePools = combinePools;
            }

            public void setHanaDatabaseIds(List<String> hanaDatabaseIds) {
                this.hanaDatabaseIds = hanaDatabaseIds;
            }
        }
    }

    public static class Messaging {
        private Enabled receiver = new Enabled(true);
        private boolean resetQueues = false;
        private List<MessagingRoute> routes = new ArrayList<MessagingRoute>();
        private Map<String, MessagingServiceConfig> services = new HashMap<String, MessagingServiceConfig>();

        public MessagingServiceConfig getService(String name) {
            return this.services.values().stream().filter(s -> Objects.equals(s.getName(), name)).findFirst().orElse(new MessagingServiceConfig(name));
        }

        public List<MessagingServiceConfig> getServicesByKind(String kind) {
            return this.services.values().stream().filter(s -> Objects.equals(s.getKind(), kind)).collect(Collectors.toList());
        }

        public List<MessagingServiceConfig> getServicesByBinding(String binding) {
            return this.services.values().stream().filter(s -> Objects.equals(s.getBinding(), binding) || s.getBinding() == null && Objects.equals(s.getName(), binding)).collect(Collectors.toList());
        }

        public Enabled getReceiver() {
            return this.receiver;
        }

        public boolean isResetQueues() {
            return this.resetQueues;
        }

        public List<MessagingRoute> getRoutes() {
            return this.routes;
        }

        public Map<String, MessagingServiceConfig> getServices() {
            return this.services;
        }

        public void setReceiver(Enabled receiver) {
            this.receiver = receiver;
        }

        public void setResetQueues(boolean resetQueues) {
            this.resetQueues = resetQueues;
        }

        public void setRoutes(List<MessagingRoute> routes) {
            this.routes = routes;
        }

        public void setServices(Map<String, MessagingServiceConfig> services) {
            this.services = services;
        }

        public static class MessagingServiceConfig
        extends Enabled {
            private String name;
            private String kind;
            private String binding;
            private String topicNamespace;
            private Connection connection = new Connection();
            private Queue queue = new Queue();

            public MessagingServiceConfig() {
                super(true);
            }

            public MessagingServiceConfig(String name) {
                super(true);
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            public String getKind() {
                return this.kind;
            }

            public String getBinding() {
                return this.binding;
            }

            public String getTopicNamespace() {
                return this.topicNamespace;
            }

            public Connection getConnection() {
                return this.connection;
            }

            public Queue getQueue() {
                return this.queue;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setKind(String kind) {
                this.kind = kind;
            }

            public void setBinding(String binding) {
                this.binding = binding;
            }

            public void setTopicNamespace(String topicNamespace) {
                this.topicNamespace = topicNamespace;
            }

            public void setConnection(Connection connection) {
                this.connection = connection;
            }

            public void setQueue(Queue queue) {
                this.queue = queue;
            }

            public static class Queue {
                private String name;
                private Integer maxFailedAttempts = 0;
                private Map<String, String> config = new HashMap<String, String>();
                private List<String> subscriptions = new ArrayList<String>();

                public String getName() {
                    return this.name;
                }

                public Integer getMaxFailedAttempts() {
                    return this.maxFailedAttempts;
                }

                public Map<String, String> getConfig() {
                    return this.config;
                }

                public List<String> getSubscriptions() {
                    return this.subscriptions;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public void setMaxFailedAttempts(Integer maxFailedAttempts) {
                    this.maxFailedAttempts = maxFailedAttempts;
                }

                public void setConfig(Map<String, String> config) {
                    this.config = config;
                }

                public void setSubscriptions(List<String> subscriptions) {
                    this.subscriptions = subscriptions;
                }
            }

            public static class Connection {
                private boolean dedicated = false;
                private Map<String, String> properties = new HashMap<String, String>();

                public boolean isDedicated() {
                    return this.dedicated;
                }

                public Map<String, String> getProperties() {
                    return this.properties;
                }

                public void setDedicated(boolean dedicated) {
                    this.dedicated = dedicated;
                }

                public void setProperties(Map<String, String> properties) {
                    this.properties = properties;
                }
            }
        }

        public static class MessagingRoute {
            private String service;
            private List<String> topics = new ArrayList<String>();

            public String getService() {
                return this.service;
            }

            public List<String> getTopics() {
                return this.topics;
            }

            public void setService(String service) {
                this.service = service;
            }

            public void setTopics(List<String> topics) {
                this.topics = topics;
            }
        }
    }

    public static class Composite {
        private Map<String, CompositeServiceConfig> services = new HashMap<String, CompositeServiceConfig>();

        public Map<String, CompositeServiceConfig> getServices() {
            return this.services;
        }

        public void setServices(Map<String, CompositeServiceConfig> services) {
            this.services = services;
        }

        public static class CompositeServiceConfig {
            private String name;
            private List<Route> routes = new ArrayList<Route>();

            public CompositeServiceConfig(String name) {
                this.name = name;
            }

            public CompositeServiceConfig() {
            }

            public String getName() {
                return this.name;
            }

            public List<Route> getRoutes() {
                return this.routes;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setRoutes(List<Route> routes) {
                this.routes = routes;
            }

            public static class Route {
                private String service;
                private List<String> events = new ArrayList<String>();

                public String getService() {
                    return this.service;
                }

                public List<String> getEvents() {
                    return this.events;
                }

                public void setService(String service) {
                    this.service = service;
                }

                public void setEvents(List<String> events) {
                    this.events = events;
                }
            }
        }
    }

    public static class ODataV2 {
        private Servlet endpoint = new Servlet("/odata/v2");
        private String edmxPath = "edmx/v2";

        public Servlet getEndpoint() {
            return this.endpoint;
        }

        public String getEdmxPath() {
            return this.edmxPath;
        }

        public void setEndpoint(Servlet endpoint) {
            this.endpoint = endpoint;
        }

        public void setEdmxPath(String edmxPath) {
            this.edmxPath = edmxPath;
        }
    }

    public static class ODataV4 {
        private Servlet endpoint = new Servlet("/odata/v4");
        private Servlet indexPage = new Servlet("/");
        private boolean contextAbsoluteUrl = false;
        private String edmxPath = "edmx/v4";

        public Servlet getEndpoint() {
            return this.endpoint;
        }

        public Servlet getIndexPage() {
            return this.indexPage;
        }

        public boolean isContextAbsoluteUrl() {
            return this.contextAbsoluteUrl;
        }

        public String getEdmxPath() {
            return this.edmxPath;
        }

        public void setEndpoint(Servlet endpoint) {
            this.endpoint = endpoint;
        }

        public void setIndexPage(Servlet indexPage) {
            this.indexPage = indexPage;
        }

        public void setContextAbsoluteUrl(boolean contextAbsoluteUrl) {
            this.contextAbsoluteUrl = contextAbsoluteUrl;
        }

        public void setEdmxPath(String edmxPath) {
            this.edmxPath = edmxPath;
        }
    }

    public static class Security {
        private boolean openUnrestrictedEndpoints = true;
        private boolean openMetadataEndpoints = false;
        private boolean authenticateUnknownEndpoints = true;
        private Enabled draftProtection = new Enabled(true);
        private Enabled instanceBasedAuthorization = new Enabled(true);
        private Xsuaa xsuaa = new Xsuaa();
        private Mock mock = new Mock();

        public boolean isOpenUnrestrictedEndpoints() {
            return this.openUnrestrictedEndpoints;
        }

        public boolean isOpenMetadataEndpoints() {
            return this.openMetadataEndpoints;
        }

        public boolean isAuthenticateUnknownEndpoints() {
            return this.authenticateUnknownEndpoints;
        }

        public Enabled getDraftProtection() {
            return this.draftProtection;
        }

        public Enabled getInstanceBasedAuthorization() {
            return this.instanceBasedAuthorization;
        }

        public Xsuaa getXsuaa() {
            return this.xsuaa;
        }

        public Mock getMock() {
            return this.mock;
        }

        public void setOpenUnrestrictedEndpoints(boolean openUnrestrictedEndpoints) {
            this.openUnrestrictedEndpoints = openUnrestrictedEndpoints;
        }

        public void setOpenMetadataEndpoints(boolean openMetadataEndpoints) {
            this.openMetadataEndpoints = openMetadataEndpoints;
        }

        public void setAuthenticateUnknownEndpoints(boolean authenticateUnknownEndpoints) {
            this.authenticateUnknownEndpoints = authenticateUnknownEndpoints;
        }

        public void setDraftProtection(Enabled draftProtection) {
            this.draftProtection = draftProtection;
        }

        public void setInstanceBasedAuthorization(Enabled instanceBasedAuthorization) {
            this.instanceBasedAuthorization = instanceBasedAuthorization;
        }

        public void setXsuaa(Xsuaa xsuaa) {
            this.xsuaa = xsuaa;
        }

        public void setMock(Mock mock) {
            this.mock = mock;
        }

        public static class Mock
        extends Enabled {
            private List<User> users = new ArrayList<User>();

            public Mock() {
                super(true);
            }

            public List<User> getUsers() {
                return this.users;
            }

            public void setUsers(List<User> users) {
                this.users = users;
            }

            public static class User {
                private String id;
                private String name;
                private String password = "";
                private String tenant;
                private boolean systemUser = false;
                private boolean privileged = false;
                private List<String> roles = new ArrayList<String>();
                private Map<String, List<String>> attributes = new HashMap<String, List<String>>();
                private List<String> unrestricted = new ArrayList<String>();
                private Map<String, Object> additional = new HashMap<String, Object>();

                public boolean isValid() {
                    return this.getName() != null && !this.getName().isEmpty() && this.getPassword() != null;
                }

                public String toString() {
                    try {
                        ObjectMapper mapper = new ObjectMapper();
                        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                        return mapper.writeValueAsString((Object)this);
                    }
                    catch (Exception e) {
                        return this.name;
                    }
                }

                public String getId() {
                    return this.id;
                }

                public String getName() {
                    return this.name;
                }

                public String getPassword() {
                    return this.password;
                }

                public String getTenant() {
                    return this.tenant;
                }

                public boolean isSystemUser() {
                    return this.systemUser;
                }

                public boolean isPrivileged() {
                    return this.privileged;
                }

                public List<String> getRoles() {
                    return this.roles;
                }

                public Map<String, List<String>> getAttributes() {
                    return this.attributes;
                }

                public List<String> getUnrestricted() {
                    return this.unrestricted;
                }

                public Map<String, Object> getAdditional() {
                    return this.additional;
                }

                public void setId(String id) {
                    this.id = id;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public void setPassword(String password) {
                    this.password = password;
                }

                public void setTenant(String tenant) {
                    this.tenant = tenant;
                }

                public void setSystemUser(boolean systemUser) {
                    this.systemUser = systemUser;
                }

                public void setPrivileged(boolean privileged) {
                    this.privileged = privileged;
                }

                public void setRoles(List<String> roles) {
                    this.roles = roles;
                }

                public void setAttributes(Map<String, List<String>> attributes) {
                    this.attributes = attributes;
                }

                public void setUnrestricted(List<String> unrestricted) {
                    this.unrestricted = unrestricted;
                }

                public void setAdditional(Map<String, Object> additional) {
                    this.additional = additional;
                }
            }
        }

        public static class Xsuaa
        extends Enabled {
            private Enabled authConfig = new Enabled(true);
            private boolean normalizeUserNames = false;
            private String serviceName;

            public Xsuaa() {
                super(true);
            }

            public Enabled getAuthConfig() {
                return this.authConfig;
            }

            public boolean isNormalizeUserNames() {
                return this.normalizeUserNames;
            }

            public String getServiceName() {
                return this.serviceName;
            }

            public void setAuthConfig(Enabled authConfig) {
                this.authConfig = authConfig;
            }

            public void setNormalizeUserNames(boolean normalizeUserNames) {
                this.normalizeUserNames = normalizeUserNames;
            }

            public void setServiceName(String serviceName) {
                this.serviceName = serviceName;
            }
        }
    }

    public static class Model {
        private String csnPath = "edmx/csn.json";

        public String getCsnPath() {
            return this.csnPath;
        }

        public void setCsnPath(String csnPath) {
            this.csnPath = csnPath;
        }
    }

    public static class DataSource {
        private boolean embedded;
        private String serviceName;
        private String csvInitializationMode = "embedded";
        private String csvFileSuffix = ".csv";
        private List<String> csvPaths = Arrays.asList("db/data/**", "db/csv/**", "../db/data/**", "../db/csv/**");

        public boolean isEmbedded() {
            return this.embedded;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getCsvInitializationMode() {
            return this.csvInitializationMode;
        }

        public String getCsvFileSuffix() {
            return this.csvFileSuffix;
        }

        public List<String> getCsvPaths() {
            return this.csvPaths;
        }

        public void setEmbedded(boolean embedded) {
            this.embedded = embedded;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public void setCsvInitializationMode(String csvInitializationMode) {
            this.csvInitializationMode = csvInitializationMode;
        }

        public void setCsvFileSuffix(String csvFileSuffix) {
            this.csvFileSuffix = csvFileSuffix;
        }

        public void setCsvPaths(List<String> csvPaths) {
            this.csvPaths = csvPaths;
        }
    }

    public static class Environment {
        private Local local = new Local();

        public Local getLocal() {
            return this.local;
        }

        public void setLocal(Local local) {
            this.local = local;
        }

        public static class Local {
            private String defaultEnvPath;

            public String getDefaultEnvPath() {
                return this.defaultEnvPath;
            }

            public void setDefaultEnvPath(String defaultEnvPath) {
                this.defaultEnvPath = defaultEnvPath;
            }
        }
    }
}

