/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.platform.local;

import com.sap.cds.feature.config.Properties;
import com.sap.cds.feature.platform.ApplicationProperties;
import com.sap.cds.feature.platform.PlatformEnvironment;
import com.sap.cds.feature.platform.ServiceBinding;
import com.sap.cds.feature.platform.util.VcapApplicationParser;
import com.sap.cds.feature.platform.util.VcapServicesParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalPlatformEnvironment
implements PlatformEnvironment {
    private static final String defaultEnv = "default-env.json";
    private static final Logger logger = LoggerFactory.getLogger(LocalPlatformEnvironment.class);
    private ApplicationProperties properties;
    private List<ServiceBinding> bindings;

    @Override
    public ApplicationProperties getApplicationProperties() {
        if (this.properties == null) {
            this.properties = VcapApplicationParser.getApplicationProperties(this.getDefaultEnv());
        }
        return this.properties;
    }

    @Override
    public Stream<ServiceBinding> getServiceBindings() {
        if (this.bindings == null) {
            this.bindings = VcapServicesParser.getServiceBindings(this.getDefaultEnv());
        }
        return this.bindings.stream();
    }

    private String getDefaultEnv() {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(defaultEnv);
        if (stream == null) {
            File defaultEnvFile = null;
            String defaultEnvPath = Properties.getCds().getEnvironment().getLocal().getDefaultEnvPath();
            if (defaultEnvPath != null) {
                defaultEnvFile = new File(defaultEnvPath);
                if (defaultEnvFile.isDirectory()) {
                    defaultEnvFile = Paths.get(defaultEnvPath, new String[0]).resolve(defaultEnv).toFile();
                }
                if (defaultEnvFile.exists()) {
                    try {
                        stream = new FileInputStream(defaultEnvFile);
                    }
                    catch (FileNotFoundException fileNotFoundException) {}
                } else {
                    logger.warn("No default env file found in configured path '{}'", (Object)defaultEnvPath);
                }
            }
            Path workingDirectory = Paths.get(System.getProperty("user.dir"), new String[0]);
            if (stream == null && (defaultEnvFile = workingDirectory.resolve(defaultEnv).toFile()).exists()) {
                try {
                    stream = new FileInputStream(defaultEnvFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (stream == null && (defaultEnvFile = workingDirectory.getParent().resolve(defaultEnv).toFile()).exists()) {
                try {
                    stream = new FileInputStream(defaultEnvFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (stream != null && defaultEnvFile != null) {
                logger.info("Loaded {} from directory '{}'", (Object)defaultEnvFile.getName(), (Object)defaultEnvFile.getParent());
            }
        } else {
            logger.info("Loaded {} from classpath resources", (Object)defaultEnv);
        }
        String defaultEnvString = null;
        if (stream != null) {
            try (Scanner scanner = new Scanner(stream, StandardCharsets.UTF_8.name());){
                defaultEnvString = scanner.useDelimiter("\\A").next();
            }
        }
        return defaultEnvString;
    }

    @Override
    public boolean isActiveFeature() {
        return true;
    }

    @Override
    public String getFeatureName() {
        return "Local Platform Environment (default-env.json)";
    }
}

