/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.util;

import com.sap.cds.Struct;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class ClassMethods {
    private final Map<String, List<Method>> classMethods = new HashMap<String, List<Method>>();
    private static final Map<Class<?>, ClassMethods> createdClassMethods = new ConcurrentHashMap();

    public static ClassMethods create(Class<?> clazz) {
        ClassMethods cachedClassMethods = createdClassMethods.get(clazz);
        if (cachedClassMethods == null) {
            cachedClassMethods = new ClassMethods(clazz);
            createdClassMethods.put(clazz, cachedClassMethods);
        }
        return cachedClassMethods;
    }

    private ClassMethods(Class<?> clazz) {
        for (Method m : clazz.getMethods()) {
            List<Method> originalMethods = this.classMethods.get(m.getName());
            if (originalMethods == null) {
                originalMethods = new ArrayList<Method>();
                this.classMethods.put(m.getName(), originalMethods);
            }
            originalMethods.add(m);
        }
    }

    public Method lookupMethod(Method proxyMethod) {
        List<Method> originalMethods = this.classMethods.get(proxyMethod.getName());
        if (originalMethods != null) {
            for (Method originalMethod : originalMethods) {
                if (originalMethod.getParameterCount() != proxyMethod.getParameterCount()) continue;
                Class<?>[] originalParameterTypes = originalMethod.getParameterTypes();
                Class<?>[] proxyParameterTypes = proxyMethod.getParameterTypes();
                boolean sameParameterList = true;
                for (int i = 0; i < originalMethod.getParameterCount(); ++i) {
                    if (originalParameterTypes[i] == proxyParameterTypes[i]) continue;
                    sameParameterList = false;
                    break;
                }
                if (!sameParameterList) continue;
                return originalMethod;
            }
        }
        return null;
    }

    public static <V, T extends V> T as(Class<T> targetClazz, Class<V> baseClazz, V impl, Supplier<Map<String, Object>> additionalData) {
        if (targetClazz.isAssignableFrom(impl.getClass())) {
            return (T)impl;
        }
        ClassMethods classMethods = ClassMethods.create(baseClazz);
        Object mapAccessor = Struct.access(additionalData.get()).as(targetClazz);
        return (T)Proxy.newProxyInstance(targetClazz.getClassLoader(), new Class[]{targetClazz, baseClazz}, (proxy, method, methodArgs) -> {
            Method originalMethod = classMethods.lookupMethod(method);
            if (originalMethod != null) {
                if (method.getName().equals("as") && methodArgs.length == 1 && ((Class)methodArgs[0]).isAssignableFrom(targetClazz)) {
                    return proxy;
                }
                return originalMethod.invoke(impl, methodArgs);
            }
            return method.invoke(mapAccessor, methodArgs);
        });
    }
}

