/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature;

/**
 * Interface for features loadable through the {@link FeatureLoader}
 */
public interface Feature {

	/**
	 * Checks if the feature is activated
	 *
	 * @return true if the feature is activated
	 */
	boolean isActiveFeature();

	/**
	 * @return a name for the feature to be used in logging
	 */
	String getFeatureName();

}
