/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature.config;

import com.sap.cds.feature.FeatureLoader;
import com.sap.cds.feature.config.local.DefaultPropertiesProvider;
import com.sap.cds.feature.config.pojo.CdsProperties;
import com.sap.cds.feature.config.pojo.PlainProperties;

/**
 * Gives access to the {@link PropertiesProvider} and property values through POJO classes, like {@link CdsProperties}
 */
public class Properties {

	private final PropertiesProvider provider;
	private final CdsProperties cds;
	private final PlainProperties plain;

	private Properties() {
		provider = FeatureLoader.getFeature(PropertiesProvider.class, () -> new DefaultPropertiesProvider());
		cds = provider.bindPropertyClass("cds", CdsProperties.class);
		plain = provider.bindPropertyClass("plain", PlainProperties.class);
	}

	private static volatile Properties properties;

	private static Properties get() {
		if(properties == null) {
			synchronized(Properties.class) {
				if(properties == null) {
					properties = new Properties();
				}
			}
		}
		return properties;
	}

	/**
	 * @return the {@link PropertiesProvider}
	 */
	public static PropertiesProvider getProvider() {
		return get().provider;
	}

	/**
	 * @return the {@link CdsProperties} POJO
	 */
	public static CdsProperties getCds() {
		return get().cds;
	}

	/**
	 * @return the {@link PlainProperties} POJO
	 */
	public static PlainProperties getPlain() {
		return get().plain;
	}

}
