/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature.config.pojo;

import java.util.Arrays;
import java.util.List;

/**
 * The POJO describing the structure of configuration properties used in plain scenario.
 */
@lombok.Getter
@lombok.Setter
public class PlainProperties {

	private String handlerPackage;
	private String datasourceJndi = "java:comp/env/jdbc/java-hdi-container";
	private String profiles = "default";
	private Messages messages = new Messages();


	@lombok.Getter
	@lombok.Setter
	public static class Messages {

		private List<String> basenames = Arrays.asList("_i18n.i18n", "i18n.i18n", "assets.i18n");

	}
}
