/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature.localization;

import java.util.Locale;

import com.sap.cds.feature.Feature;
import com.sap.cds.feature.FeatureLoader;

/**
 * A {@code LocalizedMessageProvider} is capable to build localized messages based on string formats in the application's resource bundles.
 */
public interface LocalizedMessageProvider extends Feature {

	/**
	 * Gives access to the active {@link DefaultLocalizedMessageProvider}
	 */
	LocalizedMessageProvider INSTANCE = FeatureLoader.getFeature(LocalizedMessageProvider.class, () -> new DefaultLocalizedMessageProvider());

	/**
	 * Returns the localized message for the given code, arguments and locale if existing, {@code null} otherwise.
	 * The method does not throw and returns {@code code} in case of any errors.
	 *
	 * @param code	The code which is used as key for the format string in the defined bundles.
	 * @param args	The argument objects for the format string
	 * @param locale	The locale to be used. If no locale is set the default locale is taken.
	 * @return	The localized message or {@code null} if the code is not resolvable.
	 */
	String getMessage(String code, Object[] args, Locale locale);

}
