/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature.platform;

/**
 * A {@link ApplicationProperties} provides the access to the application specific environment properties.
 * Application properties are usually defined by the platform in which the application is running.
 */
public interface ApplicationProperties {

	/**
	 * Provides the application name
	 *
	 * @return {@link String} the application name
	 */
	String getApplicationName();

	/**
	 * Provides the application ID.
	 *
	 * @return {@link String} the application ID
	 */
	String getApplicationId();
}
