/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature.platform;

import java.util.stream.Stream;

import com.sap.cds.feature.Feature;
import com.sap.cds.feature.FeatureLoader;
import com.sap.cds.feature.platform.local.LocalPlatformEnvironment;

/**
 * The {@link PlatformEnvironment} provides the configuration properties of the platform environment.
 */
public interface PlatformEnvironment extends Feature {

	/**
	 * Gives access to the active {@link PlatformEnvironment}
	 */
	PlatformEnvironment INSTANCE = FeatureLoader.getFeature(PlatformEnvironment.class, () -> new LocalPlatformEnvironment());

	/**
	 * Provides application specific properties.
	 *
	 * @return application specific properties or <code>null</code> if not available
	 */
	ApplicationProperties getApplicationProperties();

	/**
	 * Provides the available service bindings.
	 *
	 * @return a stream of all service bindings.
	 */
	Stream<ServiceBinding> getServiceBindings();

}
