/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature.services;

import com.sap.cds.feature.platform.ServiceBinding;

/**
 * A {@link ServiceDescriptor} describes how a {@link ServiceBinding} is to be turned into a service object (e.g. a DataSource)
 */
public interface ServiceDescriptor {

	/**
	 * @return the name
	 */
	String getName();

	/**
	 * @return the type of the object that is created when the service is connected
	 */
	Class<?> getConnectedType();

}
