/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature.services.db;

import javax.sql.DataSource;

import com.sap.cds.feature.platform.ServiceBinding;
import com.sap.cds.feature.services.ServiceDescriptor;

/**
 * The concrete {@link ServiceDescriptor} for {@link ServiceBinding} objects that can be turned into {@link DataSource} objects
 */
public interface DataSourceDescriptor extends ServiceDescriptor {

	@Override
	default Class<?> getConnectedType() {
		return DataSource.class;
	}

	/**
	 * @return the driver class name
	 */
	String getDriverClassName();

	/**
	 * @return the JDBC url
	 */
	String getUrl();

	/**
	 * @return the JDBC username
	 */
	String getUsername();

	/**
	 * @return the JDBC password
	 */
	String getPassword();

	/**
	 * @return true in case of an in-memory data source
	 */
	boolean isEmbedded();

}
