/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature.services.db;

import javax.sql.DataSource;

import com.sap.cds.services.runtime.CdsRuntime;

/**
 * Interface for classes that create a data source.
 */
public interface DataSourceProvider {

	DataSource create(DataSourceDescriptor descriptor);

	boolean accept(DataSourceDescriptor descriptor);

	/**
	 * Called after creation of the {@link DataSourceProvider} object to set the {@link CdsRuntime}
	 * @param runtime the {@link CdsRuntime}
	 */
	default void setRuntime(CdsRuntime runtime) {
		// not required
	}

}
