/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature.services.util;

import java.util.Iterator;
import java.util.Locale;
import java.util.Optional;
import java.util.ServiceLoader;

import com.sap.cds.feature.services.db.DataSourceDescriptor;
import com.sap.cds.feature.services.db.DataSourceProvider;
import com.sap.cds.services.runtime.CdsRuntime;

/**
 * Utility class for data source providers.
 */
public class DataSourceProviderUtils {

	public enum PoolType {
		HIKARI("hikari"),
		TOMCAT("tomcat"),
		DBCP2("dbcp2"),
		ATOMIKOS("atomikos");

		private final String poolType;

		private PoolType(String poolType) {
			this.poolType = poolType;
		}

		@Override
		public String toString() {
			return poolType;
		}
	}

	public static String getDataSourceSection(DataSourceDescriptor descriptor, PoolType poolType) {
		return String.format("cds.data-source.%s.%s", toKebabCase(descriptor.getName()), poolType);
	}

	private static String toKebabCase(String str) {
		return str.toLowerCase(Locale.US).replace("_", "-");
	}

	public static Optional<DataSourceProvider> getDataSourceProvider(DataSourceDescriptor descriptor, CdsRuntime runtime) {
		ServiceLoader<DataSourceProvider> providerLoader = ServiceLoader.load(DataSourceProvider.class);
		Iterator<DataSourceProvider> iter = providerLoader.iterator();
		while (iter.hasNext()) {
			DataSourceProvider provider = iter.next();
			provider.setRuntime(runtime);
			if (provider.accept(descriptor)) {
				return Optional.of(provider);
			}
		}
		return Optional.empty();
	}

}
