/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature.services.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;

import javax.sql.DataSource;

import com.sap.cds.feature.platform.PlatformEnvironment;
import com.sap.cds.feature.platform.ServiceBinding;
import com.sap.cds.feature.services.ServiceDescriptor;
import com.sap.cds.feature.services.ServiceDescriptorCreator;
import com.sap.cds.feature.services.db.DataSourceDescriptor;

/**
 * Gives access to the {@link ServiceDescriptor}s by loading all {@link ServiceDescriptorCreator} implementations
 * and providing them with the {@link ServiceBinding} instances of the active {@link PlatformEnvironment}
 */
public class ServiceDescriptorUtils {

	/**
	 * @return the list of available service descriptor objects
	 */
	private static List<ServiceDescriptor> getServiceDescriptors() {
		ServiceLoader<ServiceDescriptorCreator> configurationLoader = ServiceLoader.load(ServiceDescriptorCreator.class);
		Iterator<ServiceDescriptorCreator> cfgLoaders = configurationLoader.iterator();

		List<ServiceDescriptor> descriptors = new ArrayList<>();
		while(cfgLoaders.hasNext()) {
			descriptors.addAll(cfgLoaders.next().create());
		}
		return descriptors;
	}

	/**
	 * @return the list of available datasource descriptor objects
	 */
	public static List<DataSourceDescriptor> getDataSourceDescriptors() {
		return getServiceDescriptors().stream()
				.filter(d -> DataSource.class.isAssignableFrom(d.getConnectedType()) && d instanceof DataSourceDescriptor)
				.map(d -> (DataSourceDescriptor) d)
				.collect(Collectors.toList());
	}

}
