| Property | Type | Default Value | Description |
| --- | --- | --- | --- |
| **cds.environment** |  |  | Properties for environments, like local development or CloudFoundry. |
| **cds.environment.local** |  |  | Properties for the local environment. |
| `cds.environment.local.`<wbr>`defaultEnvPath` | `String` |  | File-system path to the default environment JSON file.<br>The file follows the structure of CloudFoundry's VCAP_SERVICES and VCAP_APPLICATION environment variables.<br>If this property specifies a folder, the filename `default-env.json` is appended to it. |
| **cds.environment.k8s** |  |  | Properties for Kubernetes. |
| `cds.environment.k8s.se`<wbr>`cretsPath` | `String` | `/etc/secre`<wbr>`ts/sapcp` | Secrets directory where service bindings are found according to the following conventions:<br>`[secretsPath]/[serviceName]/[serviceInstanceName]`<br>`[serviceName]` and `[serviceInstanceName]` are directories with the name of the service and service instance respectively.<br>The directory `[serviceInstanceName]` must contain the service binding credentials as files with its name being the key and its content being the value. |
| **cds.environment.k8s.se<wbr>rviceBindings** |  |  | Properties to explicitly configure service bindings with an arbitrary secrets path.<br>The metadata for these service bindings can be fully specified, to ensure CAP is able detect the binding in auto-configuration.<br>The key can be chosen arbitrarily and is used as the service binding name, if the name property is not explicitly defined. |
| `cds.environment.k8s.se`<wbr>`rviceBindings.<key>.na`<wbr>`me` | `String` |  | The name of the service binding. |
| `cds.environment.k8s.se`<wbr>`rviceBindings.<key>.se`<wbr>`cretsPath` | `String` |  | The path to the secrets directory. |
| `cds.environment.k8s.se`<wbr>`rviceBindings.<key>.se`<wbr>`rvice` | `String` |  | The name of the service. |
| `cds.environment.k8s.se`<wbr>`rviceBindings.<key>.pl`<wbr>`an` | `String` |  | The optional name of the service plan. |
| `cds.environment.k8s.se`<wbr>`rviceBindings.<key>.ta`<wbr>`gs` | `List<String>` |  | The optional list of service tags. |
| **cds.dataSource** |  |  | Properties for the primary data source used by the default persistence service. |
| `cds.dataSource.embedde`<wbr>`d` | `boolean` | `false` | Determines, if the data source is considered embedded (in-memory). |
| `cds.dataSource.binding` | `String` |  | The name of the primary service binding, used by the default persistence service. |
| `cds.dataSource.csvInit`<wbr>`ializationMode` | `String` | `embedded` | Determines in which scenarios the default persistence service is initialized with CSV data.<br>By default CSV initialization only happens, if the data source is embedded (in-memory).<br>Possible values are: `embedded`, `never`, `always`. |
| `cds.dataSource.csvFile`<wbr>`Suffix` | `String` | `.csv` | The file suffix of CSV files. |
| `cds.dataSource.csvPath`<wbr>`s` | `List<String>` | `db/data/**, db/csv/**, ../db/data/**, ../db/csv/**` | The file-system paths to search for CSV files in.<br>Using `/**` at the end of the path triggers a recursive search. |
| **cds.model** |  |  | Properties for the CDS model. |
| `cds.model.csnPath` | `String` | `edmx/csn.j`<wbr>`son` | The resource path to the csn.json file. |
| **cds.security** |  |  | Properties for security configurations of services and endpoints. |
| `cds.security.openUnres`<wbr>`trictedEndpoints` | `boolean` |  | Determines, if protocol adapter endpoints that do not require authorization also do not enforce authentication.<br>If not set explicitly, a reasonable default value is derived the from the application scenario:<br>In the multitenant scenario, which usually requires authentication to obtain the tenant information, the default value is `false`.<br>For all other scenarios, `true` is the default value. |
| `cds.security.openMetad`<wbr>`ataEndpoints` | `boolean` | `false` | Determines, if OData $metadata endpoints are available without authentication. |
| `cds.security.authentic`<wbr>`ateUnknownEndpoints` | `boolean` | `true` | Determines, if security configurations enforce authentication for endpoints not managed by CAP protocol-adapters. |
| **cds.security.draftProt<wbr>ection** |  |  | Properties to control the protection of drafts.<br>If a draft is protected it is only accessible by its creator. |
| `cds.security.draftProt`<wbr>`ection.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.security.xsuaa** |  |  | Properties for XSUAA based authentication. |
| `cds.security.xsuaa.bin`<wbr>`ding` | `String` |  | The name of the XSUAA service binding, used for the XSUAA security auto-configuration. |
| `cds.security.xsuaa.ena`<wbr>`bled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.security.xsuaa.aut<wbr>hConfig** |  |  | Properties for the XSUAA Spring security auto-configuration. |
| `cds.security.xsuaa.aut`<wbr>`hConfig.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.security.mock** |  |  | Properties for mock-user based authentication. |
| `cds.security.mock.enab`<wbr>`led` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.security.mock.user<wbr>s** |  |  | The list of mock-users, used for basic authentication in local development and test scenarios. |
| `cds.security.mock.user`<wbr>`s.<index>.id` | `String` |  | The ID of the mock-user. |
| `cds.security.mock.user`<wbr>`s.<index>.name` | `String` |  | The (mandatory) name of the mock-user.<br>It is used to perform the basic authentication. |
| `cds.security.mock.user`<wbr>`s.<index>.password` | `String` |  | The (optional) password of the mock-user.<br>It is used to perform the basic authentication. |
| `cds.security.mock.user`<wbr>`s.<index>.tenant` | `String` |  | The tenant of the mock-user. |
| `cds.security.mock.user`<wbr>`s.<index>.systemUser` | `boolean` | `false` | Determines, if this mock-user is treated as a system user. |
| `cds.security.mock.user`<wbr>`s.<index>.privileged` | `boolean` | `false` | Determines, if this mock-user is treated as the privileged user. |
| `cds.security.mock.user`<wbr>`s.<index>.roles` | `List<String>` |  | The list of roles, that are assigned to this mock-user. |
| `cds.security.mock.user`<wbr>`s.<index>.attributes` | `Map<String,L`<wbr>`ist<String>>` |  | A map of user attributes, that are assigned to the mock-user.<br>The name of the attribute needs to be given as the key.<br>The attribute values are provided as a list. |
| `cds.security.mock.user`<wbr>`s.<index>.unrestricted` | `List<String>` |  | A list of attribute names, for which the mock-user has no restrictions.<br>This is treated as if the mock-user effectively had all possible values of this attribute assigned. |
| `cds.security.mock.user`<wbr>`s.<index>.additional` | `Map<String,O`<wbr>`bject>` |  | A map of additional properties of the mock-user.<br>It can be used to mock authentication specific properties (e.g. email address).<br>The name of the additional attribute needs to be given as the key.<br>The value of the attribute can be provided as an arbitrary object. |
| **cds.indexPage** |  |  | Properties for the index page. |
| `cds.indexPage.path` | `String` | `/` | The base-path of the adapter endpoint. |
| `cds.indexPage.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.odataV4** |  |  | Properties for the OData V4 protocol adapter. |
| `cds.odataV4.contextAbs`<wbr>`oluteUrl` | `boolean` | `false` | Determines, if URLs in the @odata.context response annotation are absolute. |
| `cds.odataV4.edmxPath` | `String` | `edmx/v4` | The JAR resource path to search for OData V4 EDMX files. |
| **cds.odataV4.endpoint** |  |  | Properties of the OData V4 protocol adapter endpoint. |
| `cds.odataV4.endpoint.p`<wbr>`ath` | `String` | `/odata/v4` | The base-path of the adapter endpoint. |
| `cds.odataV4.endpoint.e`<wbr>`nabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.odataV2** |  |  | Properties for the OData V2 protocol adapter. |
| `cds.odataV2.edmxPath` | `String` | `edmx/v2` | The JAR resource path to search for OData V2 EDMX files. |
| **cds.odataV2.endpoint** |  |  | Properties of the OData V2 protocol adapter endpoint. |
| `cds.odataV2.endpoint.p`<wbr>`ath` | `String` | `/odata/v2` | The base-path of the adapter endpoint. |
| `cds.odataV2.endpoint.e`<wbr>`nabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.messaging** |  |  | Properties for messaging services. |
| **cds.messaging.routes** |  |  | The list of routes for the composite messaging service.<br>The first route that matches is used. Therefore the order of these routes has significance. |
| `cds.messaging.routes.<`<wbr>`index>.service` | `String` |  | The target service of the route. |
| `cds.messaging.routes.<`<wbr>`index>.events` | `List<String>` |  | The list of events/topics, which are propagated to/from the target service. |
| **cds.messaging.services** |  |  | Properties for messaging services.<br>The key can be chosen arbitrarily and is used as the messaging service name, if the name property is not explicitly defined.<br>In addition it can leveraged to split configuration across multiple profiles. |
| `cds.messaging.services`<wbr>`.<key>.name` | `String` |  | The name of the messaging service. |
| `cds.messaging.services`<wbr>`.<key>.kind` | `String` |  | The kind of the messaging service.<br>It usually reflects the corresponding service binding type.<br>Possible values are: `file-based-messaging`, `enterprise-messaging`, `mqueue-sandbox`. |
| `cds.messaging.services`<wbr>`.<key>.binding` | `String` |  | The name of the service binding used for this messaging service.<br>In case of file-based-messaging this specifies the file-system path to the exchange file. |
| `cds.messaging.services`<wbr>`.<key>.topicNamespace` | `String` |  | The namespace used to prefix topics from event handler registrations when creating their queue subscription. |
| `cds.messaging.services`<wbr>`.<key>.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.messaging.services<wbr>.\<key\>.connection** |  |  | Properties for the JMS client connection. |
| `cds.messaging.services`<wbr>`.<key>.connection.dedi`<wbr>`cated` | `boolean` | `false` | Determines, if this messaging service uses its own dedicated JMS client connection.<br>By default, JMS client connections to the same messaging broker are shared. |
| `cds.messaging.services`<wbr>`.<key>.connection.prop`<wbr>`erties` | `Map<String,S`<wbr>`tring>` |  | Properties passed to the JMS client connection.<br>The possible keys and values depend on the messaging service implementation. |
| **cds.messaging.services<wbr>.\<key\>.queue** |  |  | Properties of the queue that is created for the messaging service. |
| `cds.messaging.services`<wbr>`.<key>.queue.name` | `String` |  | The name of the queue.<br>The queue may already exist with some custom configuration. In that case the queue is not recreated. |
| `cds.messaging.services`<wbr>`.<key>.queue.maxFailed`<wbr>`Attempts` | `Integer` | `0` | Specifies the amount of times a message from the message broker is emitted on the messaging service, before it is silently acknowledged in case of continuous errors. |
| `cds.messaging.services`<wbr>`.<key>.queue.config` | `Map<String,S`<wbr>`tring>` |  | Properties passed to the messaging broker when creating the queue.<br>The possible keys and values depend on the messaging service implementation. |
| `cds.messaging.services`<wbr>`.<key>.queue.subscript`<wbr>`ions` | `List<String>` |  | A list of additional topic, that are subscribed on the queue.<br>By default event handler registrations should be used to trigger subscriptions.<br>This property is intended for purposes when subscriptions can not be inferred from event handler registrations. |
| **cds.multiTenancy** |  |  | Properties for multitenancy and extensibility. |
| **cds.multiTenancy.endpo<wbr>int** |  |  | Properties of the subscription HTTP endpoints. |
| `cds.multiTenancy.endpo`<wbr>`int.path` | `String` | `/mt/v1.0/s`<wbr>`ubscriptio`<wbr>`ns` | The base-path of the adapter endpoint. |
| `cds.multiTenancy.endpo`<wbr>`int.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.multiTenancy.dataS<wbr>ource** |  |  | Properties for the multi-tenant aware datasource. |
| `cds.multiTenancy.dataS`<wbr>`ource.pool` | `String` | `hikari` | Pool to use for the multi-tenant aware datasource.<br>Possible values are: `hikari`, `tomcat`, `atomikos`. |
| **cds.multiTenancy.servi<wbr>ceManager** |  |  | Properties for the instance-manager / service-manager client. |
| `cds.multiTenancy.servi`<wbr>`ceManager.timeout` | `int` | `3600` | The timeout for requests in seconds. |
| **cds.multiTenancy.secur<wbr>ity** |  |  | Properties for authorization. |
| `cds.multiTenancy.secur`<wbr>`ity.subscriptionScope` | `String` | `mtcallback` | The scope by which the subscription endpoints are authorized. |
| `cds.multiTenancy.secur`<wbr>`ity.deploymentScope` | `String` | `mtdeployme`<wbr>`nt` | The scope by which the deployment endpoints are authorized. |
| **cds.multiTenancy.sidec<wbr>ar** |  |  | Properties for the MTX sidecar client. |
| `cds.multiTenancy.sidec`<wbr>`ar.url` | `String` |  | The URL of the MTX sidecar.<br>Setting this property in combination with a present service-manager service binding activates the MTX features. |
| **cds.multiTenancy.sidec<wbr>ar.cache** |  |  | Properties for the sidecar CDS model and EDMX metadata caches. |
| `cds.multiTenancy.sidec`<wbr>`ar.cache.maxSize` | `int` | `20` | The number of entries in the CDS model and EDMX metadata caches. |
| `cds.multiTenancy.sidec`<wbr>`ar.cache.expirationTim`<wbr>`e` | `int` | `600` | The lifetime of an entry in seconds after the entry's creation, the most recent replacement of its value, or its last access. |
| `cds.multiTenancy.sidec`<wbr>`ar.cache.refreshTime` | `int` | `60` | The time in seconds after which a cached entry is refreshed. |
| **cds.multiTenancy.appUi** |  |  | Properties for the URL to the application's UI endpoints. |
| `cds.multiTenancy.appUi`<wbr>`.url` | `String` |  | The URL to the application's UI, used for the 'Go to Application' link. |
| `cds.multiTenancy.appUi`<wbr>`.tenantSeparator` | `String` |  | The separator for the tenant in the URL.<br>Possible values are: `.`, `-`. |
| **cds.multiTenancy.healt<wbr>hCheck** |  |  | Properties for health check of the multi-tenant aware datasource. |
| `cds.multiTenancy.healt`<wbr>`hCheck.healthCheckStat`<wbr>`ement` | `String` |  | The statement that is used when executing a health check of the multi-tenant aware datasource. |
| `cds.multiTenancy.healt`<wbr>`hCheck.intervalMillis` | `long` | `10000` | The time in milliseconds a health check result is cached and no further health-checks are performed. |
| `cds.multiTenancy.healt`<wbr>`hCheck.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.application** |  |  | Properties for application services. |
| **cds.application.servic<wbr>es** |  |  | Properties for application services.<br>The key can be chosen arbitrarily and is used as the application service name, if the name property is not explicitly defined.<br>In addition it can leveraged to split configuration across multiple profiles. |
| `cds.application.servic`<wbr>`es.<key>.model` | `String` |  | The qualified name of the CDS service, which is the model definition of this application service.<br>It defaults to the name of the application service itself. |
| `cds.application.servic`<wbr>`es.<key>.name` | `String` |  | The name of the CDS definition. |
| **cds.application.servic<wbr>es.\<key\>.serve** |  |  | Properties to configure how this service is served by protocol adapters. |
| `cds.application.servic`<wbr>`es.<key>.serve.ignore` | `boolean` | `false` | Determines, if the service is ignored by protocol adapters. |
| `cds.application.servic`<wbr>`es.<key>.serve.path` | `String` |  | The path this service should be served at by protocol adapters.<br>The path is appended to the protocol adapter's base path.<br>If a service is served by multiple protocol adapters, each adapter serves the service under this path. |
| `cds.application.servic`<wbr>`es.<key>.serve.protoco`<wbr>`ls` | `List<String>` |  | The list of protocols adapters this service should be served by.<br>By default the service is served by all available protocol adapters.<br>Possible values are: `odata-v4`, `odata-v2`. |
| **cds.application.servic<wbr>es.\<key\>.serve.endpo<wbr>ints** |  |  | Properties to control more fine-grained under which endpoints this service is served.<br>These properties override the more general properties `paths` and `protocols`. |
| `cds.application.servic`<wbr>`es.<key>.serve.endpoin`<wbr>`ts.<index>.path` | `String` |  | The path, this endpoint should be served at by the protocol adapter.<br>The path is appended to the protocol adapter's base path. |
| `cds.application.servic`<wbr>`es.<key>.serve.endpoin`<wbr>`ts.<index>.protocol` | `String` |  | The protocol adapter that serves this endpoint.<br>Possible values are: `odata-v4`, `odata-v2`. |
| **cds.remote** |  |  | Properties for remote services. |
| **cds.remote.services** |  |  | Properties for remote services.<br>The key can be chosen arbitrarily and is mainly intended to be able to split configuration across multiple profiles. |
| `cds.remote.services.<k`<wbr>`ey>.name` | `String` |  | The name of the remote service. |
| `cds.remote.services.<k`<wbr>`ey>.model` | `String` |  | The qualified name of the CDS service, which is the model definition of this remote service.<br>It defaults to the name of the remote service itself. |
| **cds.remote.services.\<<wbr>key\>.destination** |  |  | Properties to configure a remote destination for this remote service. |
| `cds.remote.services.<k`<wbr>`ey>.destination.type` | `String` | `odata-v4` | The protocol type of the destination.<br>Possible values are: `odata-v4` or `odata-v2`. |
| `cds.remote.services.<k`<wbr>`ey>.destination.name` | `String` |  | The name of the destination in the destination service or Cloud SDK destination accessor. |
| `cds.remote.services.<k`<wbr>`ey>.destination.suffix` | `String` |  | A suffix for this destination, that is appended to the destination's URL. |
| `cds.remote.services.<k`<wbr>`ey>.destination.servic`<wbr>`e` | `String` |  | The name of the service, that is appended to the destination's URL (after the suffix).<br>It defaults to the qualified name of the model definition. |
| **cds.locales** |  |  | Properties for locale configurations. |
| **cds.locales.normalizat<wbr>ion** |  |  | Properties to configure how locales should be normalized. |
| `cds.locales.normalizat`<wbr>`ion.defaults` | `boolean` | `true` | Determines, if the non-normalization include list, as described in the documentation, is applied. |
| `cds.locales.normalizat`<wbr>`ion.includeList` | `List<String>` |  | The list of additional locales to add to the include list of non-normalized locales. |
| **cds.errors** |  |  | Properties for error handling. |
| `cds.errors.extended` | `boolean` | `false` | Determines, if error messages are automatically extended with additional debug information (only for development). |
| **cds.errors.stackMessag<wbr>es** |  |  | Properties to configure how error messages from the framework are treated.<br>If turned off, only framework error messages, that are explicitly localized are returned.<br>Other errors are mapped to their plain HTTP error code representation. |
| `cds.errors.stackMessag`<wbr>`es.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.drafts** |  |  | Properties for draft-enabled entities. |
| `cds.drafts.cancellatio`<wbr>`nTimeout` | `Duration` | `PT15M` | The maximum amount of time, since the last change, an entity instance is locked by the user who is editing its draft version. |
| `cds.drafts.deletionTim`<wbr>`eout` | `Duration` | `PT720H` | The maximum amount of time a draft is kept, before it is garbage collected. |
| **cds.drafts.gc** |  |  | Properties to configure the automatic draft garbage collection. |
| `cds.drafts.gc.interval` | `Duration` | `PT6H` | The interval, in which the automatic draft garbage collection is triggered. |
| `cds.drafts.gc.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.query** |  |  | Properties for augmentation of CQN queries. |
| **cds.query.limit** |  |  | Properties for server-driven paging. |
| `cds.query.limit.defaul`<wbr>`t` | `int` | `0` | The default page size for server-driven paging.<br>Setting this property to 0 or -1 disables the default page size. |
| `cds.query.limit.max` | `int` | `1000` | The maximum page size for server-driven paging.<br>Setting this property to 0 or -1 disables the maximum page size. |
| **cds.query.implicitSort<wbr>ing** |  |  | Properties for the implicit-sorting feature. |
| `cds.query.implicitSort`<wbr>`ing.enabled` | `boolean` | `true` | Determines, if it is enabled. |
