/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.services.util;

import com.sap.cds.feature.services.ServiceDescriptor;
import com.sap.cds.feature.services.ServiceDescriptorCreator;
import com.sap.cds.feature.services.db.DataSourceDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import javax.sql.DataSource;

public class ServiceDescriptorUtils {
    private static List<ServiceDescriptor> getServiceDescriptors() {
        ServiceLoader<ServiceDescriptorCreator> configurationLoader = ServiceLoader.load(ServiceDescriptorCreator.class);
        Iterator<ServiceDescriptorCreator> cfgLoaders = configurationLoader.iterator();
        ArrayList<ServiceDescriptor> descriptors = new ArrayList<ServiceDescriptor>();
        while (cfgLoaders.hasNext()) {
            descriptors.addAll(cfgLoaders.next().create());
        }
        return descriptors;
    }

    public static List<DataSourceDescriptor> getDataSourceDescriptors() {
        return ServiceDescriptorUtils.getServiceDescriptors().stream().filter(d -> DataSource.class.isAssignableFrom(d.getConnectedType()) && d instanceof DataSourceDescriptor).map(d -> (DataSourceDescriptor)d).collect(Collectors.toList());
    }
}

