/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.localization;

import com.sap.cds.feature.config.Properties;
import com.sap.cds.feature.localization.LocalizedMessageProvider;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class DefaultLocalizedMessageProvider
implements LocalizedMessageProvider {
    private static final Logger logger = LoggerFactory.getLogger(DefaultLocalizedMessageProvider.class);
    private final Map<LocaleCode, MessageFormat> cachedMessageFormats = new ConcurrentHashMap<LocaleCode, MessageFormat>();
    private static final MessageFormat NotFoundMessageFormat = new MessageFormat("<not found>");
    static final Locale SAPTRC_LOCALE = Locale.forLanguageTag("en-US-x-saptrc");
    static final Locale SAPTRC_BUNDLE = Locale.forLanguageTag("en-US-saptrc");
    static final Locale SAPPSD_LOCALE = Locale.forLanguageTag("en-US-x-sappsd");
    static final Locale SAPPSD_BUNDLE = Locale.forLanguageTag("en-US-sappsd");

    public static Locale getLocaleForBundle(Locale locale) {
        if (SAPTRC_LOCALE.equals(locale)) {
            return SAPTRC_BUNDLE;
        }
        if (SAPPSD_LOCALE.equals(locale)) {
            return SAPPSD_BUNDLE;
        }
        return locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMessage(String code, Object[] args, Locale locale) {
        if (code == null) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            MessageFormat messageFormat = this.findMessageFormat(code, DefaultLocalizedMessageProvider.getLocaleForBundle(locale));
            if (messageFormat != null) {
                MessageFormat messageFormat2 = messageFormat;
                synchronized (messageFormat2) {
                    Object[] theArgs = args != null && args.length > 0 ? args : new Object[]{};
                    return messageFormat.format(theArgs);
                }
            }
            return MessageFormatter.arrayFormat((String)code, (Object[])args).getMessage();
        }
        catch (Exception e) {
            logger.warn("Invalid message format '{}' or incompatible arguments {}", new Object[]{code, DefaultLocalizedMessageProvider.toStringSafely(args), e});
            return code;
        }
    }

    private static String toStringSafely(Object[] args) {
        if (args != null) {
            StringBuffer sb = new StringBuffer();
            for (Object arg : args) {
                sb.append('<');
                try {
                    sb.append(arg.toString());
                }
                catch (Exception e) {
                    sb.append(e.getMessage());
                }
                sb.append('>');
            }
            return sb.toString();
        }
        return "<null>";
    }

    @Override
    public boolean isActiveFeature() {
        return true;
    }

    @Override
    public String getFeatureName() {
        return "Default Localized Message Provider";
    }

    protected MessageFormat findMessageFormat(String code, Locale locale) {
        LocaleCode localeCode = new LocaleCode(code, locale);
        MessageFormat cachedMessageFormat = this.cachedMessageFormats.get(localeCode);
        if (cachedMessageFormat == null) {
            cachedMessageFormat = this.resolveMessageFormat(code, locale);
            if (cachedMessageFormat == null) {
                this.cachedMessageFormats.put(localeCode, NotFoundMessageFormat);
            } else {
                this.cachedMessageFormats.put(localeCode, cachedMessageFormat);
            }
        } else if (cachedMessageFormat == NotFoundMessageFormat) {
            return null;
        }
        return cachedMessageFormat;
    }

    protected MessageFormat resolveMessageFormat(String code, Locale locale) {
        List<String> basenames = Properties.getPlain().getMessages().getBasenames();
        for (String basename : basenames) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(basename, locale);
                if (!bundle.containsKey(code)) continue;
                try {
                    String msg = bundle.getString(code);
                    return new MessageFormat(msg, locale);
                }
                catch (MissingResourceException e) {
                    logger.warn("Failed to lookup '{}' from bundle '{}'", new Object[]{code, bundle.getBaseBundleName(), e});
                }
            }
            catch (MissingResourceException ex) {
                logger.warn("ResourceBundle '{}' not found: {} ", (Object)basename, (Object)ex.getMessage());
            }
        }
        return null;
    }

    private static class LocaleCode {
        String code;
        Locale locale;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
            result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LocaleCode other = (LocaleCode)obj;
            if (this.code == null ? other.code != null : !this.code.equals(other.code)) {
                return false;
            }
            return !(this.locale == null ? other.locale != null : !this.locale.equals(other.locale));
        }

        LocaleCode(String code, Locale locale) {
            this.code = code;
            this.locale = locale;
        }
    }
}

