/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.services.util;

import com.sap.cds.feature.services.db.DataSourceDescriptor;
import com.sap.cds.feature.services.db.DataSourceProvider;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.Locale;
import java.util.Optional;
import java.util.ServiceLoader;

public class DataSourceProviderUtils {
    public static String getDataSourceSection(DataSourceDescriptor descriptor, PoolType poolType) {
        return String.format("cds.data-source.%s.%s", new Object[]{DataSourceProviderUtils.toKebabCase(descriptor.getName()), poolType});
    }

    private static String toKebabCase(String str) {
        return str.toLowerCase(Locale.US).replace("_", "-");
    }

    public static Optional<DataSourceProvider> getDataSourceProvider(DataSourceDescriptor descriptor, CdsRuntime runtime) {
        ServiceLoader<DataSourceProvider> providerLoader = ServiceLoader.load(DataSourceProvider.class);
        for (DataSourceProvider provider : providerLoader) {
            provider.setRuntime(runtime);
            if (!provider.accept(descriptor)) continue;
            return Optional.of(provider);
        }
        return Optional.empty();
    }

    public static enum PoolType {
        HIKARI("hikari"),
        TOMCAT("tomcat"),
        DBCP2("dbcp2"),
        ATOMIKOS("atomikos");

        private final String poolType;

        private PoolType(String poolType) {
            this.poolType = poolType;
        }

        public String toString() {
            return this.poolType;
        }
    }
}

