/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature;

import com.sap.cds.feature.Feature;
import com.sap.cds.services.runtime.ExtendedServiceLoader;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureLoader {
    private static final Logger logger = LoggerFactory.getLogger(FeatureLoader.class);
    private static Set<Feature> loadedFeatures = ConcurrentHashMap.newKeySet();

    public static <T extends Feature> T getFeature(Class<T> featureInterface, Supplier<T> defaultFeature) {
        Feature feature = FeatureLoader.loadFeatures(featureInterface).filter(Feature::isActiveFeature).findFirst().orElse(null);
        if (feature == null && defaultFeature != null) {
            feature = (Feature)defaultFeature.get();
        }
        if (feature != null) {
            logger.info("Loaded feature '{}'", (Object)feature.getFeatureName());
            loadedFeatures.add(feature);
        }
        return (T)feature;
    }

    public static <T extends Feature> List<T> getFeatureList(Class<T> featureInterface, Supplier<T> defaultFeature) {
        List featureList = FeatureLoader.loadFeatures(featureInterface).filter(Feature::isActiveFeature).collect(Collectors.toList());
        if (featureList.isEmpty() && defaultFeature != null) {
            featureList.add(defaultFeature.get());
        }
        for (Feature feature : featureList) {
            logger.info("Loaded feature '{}'", (Object)feature.getFeatureName());
            loadedFeatures.add(feature);
        }
        return Collections.unmodifiableList(featureList);
    }

    public static Stream<Feature> loadedFeatures() {
        return loadedFeatures.stream();
    }

    private static <T extends Feature> Stream<T> loadFeatures(Class<T> featureInterface) {
        Iterable iterable = () -> ExtendedServiceLoader.loadAll((Class)featureInterface);
        return StreamSupport.stream(iterable.spliterator(), false);
    }
}

