/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.config.local;

import com.sap.cds.feature.config.PropertiesProvider;
import com.sap.cds.feature.config.pojo.CdsProperties;
import com.sap.cds.feature.config.pojo.PlainProperties;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.representer.Representer;

public class DefaultPropertiesProvider
implements PropertiesProvider {
    private final String configFile = System.getProperty("configFile", "application.yaml");
    private final String configProfile = System.getProperty("configProfile", "default");
    private PropertiesRoot root;
    private Map<String, Object> yamlMap = new HashMap<String, Object>();
    private Map<String, Object> systemPropsMap = new HashMap<String, Object>();
    private Map<String, Object> envMap = new HashMap<String, Object>();

    public DefaultPropertiesProvider() {
        this.loadYaml();
        this.loadEnvironmentVariables();
        this.loadSystemProperties();
    }

    private void loadYaml() {
        InputStream mapInputStream;
        Yaml yaml;
        int position = -1;
        InputStream pojoInputStream = DefaultPropertiesProvider.class.getClassLoader().getResourceAsStream(this.configFile);
        if (pojoInputStream != null) {
            Representer representer = new Representer();
            representer.getPropertyUtils().setSkipMissingProperties(true);
            yaml = new Yaml((BaseConstructor)new CustomConstructor(PropertiesRoot.class), representer);
            for (Object object : yaml.loadAll(pojoInputStream)) {
                PropertiesRoot properties;
                String[] profiles;
                ++position;
                if (!(object instanceof PropertiesRoot) || !Arrays.asList(profiles = (properties = (PropertiesRoot)object).getPlain().getProfiles().split(",")).stream().map(p -> p.trim()).anyMatch(p -> p.equals(this.configProfile))) continue;
                this.root = properties;
                break;
            }
        }
        if (this.root != null && position >= 0 && (mapInputStream = DefaultPropertiesProvider.class.getClassLoader().getResourceAsStream(this.configFile)) != null) {
            yaml = new Yaml();
            int p2 = -1;
            for (Object object : yaml.loadAll(mapInputStream)) {
                if (position != ++p2 || !(object instanceof Map)) continue;
                this.writeToYamlMap(null, (Map)object);
            }
        }
        if (this.root == null) {
            this.root = new PropertiesRoot();
        }
    }

    private void writeToYamlMap(String prefix, Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key = prefix == null ? entry.getKey().toString() : prefix + "." + entry.getKey().toString();
            if (entry.getValue() instanceof Map) {
                this.writeToYamlMap(key, (Map)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Iterable) continue;
            this.yamlMap.put(this.normalizeKey(key), entry.getValue());
        }
    }

    private void loadSystemProperties() {
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            this.handleProperty(this.root, (String)entry.getKey(), (String)entry.getValue());
            this.systemPropsMap.put(this.normalizeKey((String)entry.getKey()), entry.getValue());
        }
    }

    private void loadEnvironmentVariables() {
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            this.handleProperty(this.root, entry.getKey(), entry.getValue());
            this.envMap.put(this.normalizeKey(entry.getKey()), entry.getValue());
        }
    }

    private void handleProperty(Object root, String propertyKey, String propertyValue) {
        Object obj = root;
        String key = this.normalizeKey(propertyKey);
        String[] keyParts = key.split("\\.");
        for (int i = 0; i < keyParts.length; ++i) {
            String keyPart = keyParts[i];
            boolean getter = i < keyParts.length - 1;
            Method method = this.findGetterOrSetterMethod(obj.getClass(), getter, keyPart);
            if (method == null) {
                return;
            }
            try {
                if (getter) {
                    obj = method.invoke(obj, new Object[0]);
                    continue;
                }
                method.invoke(obj, this.convertValue(propertyValue, method.getParameters()[0].getType()));
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to handle property " + propertyKey, e);
            }
        }
    }

    private String normalizeKey(String key) {
        return key.replace("-", "").replace("_", ".").toLowerCase(Locale.ENGLISH);
    }

    private Method findGetterOrSetterMethod(Class<?> clazz, boolean getter, String name) {
        for (Method method : clazz.getMethods()) {
            String methodName = method.getName().toLowerCase(Locale.ENGLISH);
            if (!(getter ? (methodName.startsWith("get") && methodName.equals("get" + name) || methodName.startsWith("is") && methodName.equals("is" + name)) && method.getParameterCount() == 0 && !method.getReturnType().equals(Void.TYPE) : methodName.startsWith("set") && methodName.equals("set" + name) && method.getParameterCount() == 1 && method.getReturnType().equals(Void.TYPE))) continue;
            return method;
        }
        return null;
    }

    private <T> T convertValue(String value, Class<T> type) {
        if (type.equals(String.class)) {
            return (T)value;
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return (T)Integer.valueOf(Integer.parseInt(value));
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return (T)Long.valueOf(Long.parseLong(value));
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return (T)Boolean.valueOf(Boolean.parseBoolean(value));
        }
        if (type.equals(Duration.class)) {
            return (T)Duration.parse(value);
        }
        throw new UnsupportedOperationException("Type " + type + " not supported");
    }

    @Override
    public <T> T bindPropertyClass(String section, Class<T> clazz) {
        if ("cds".equals(section) && CdsProperties.class.equals(clazz)) {
            return (T)this.root.getCds();
        }
        if ("plain".equals(section) && PlainProperties.class.equals(clazz)) {
            return (T)this.root.getPlain();
        }
        throw new UnsupportedOperationException("Currently only CdsProperties and PlainProperties are supported");
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String normalizedKey = this.normalizeKey(key);
        Object value = this.systemPropsMap.get(normalizedKey);
        if (value == null) {
            value = this.envMap.get(normalizedKey);
        }
        if (value == null) {
            value = this.yamlMap.get(normalizedKey);
        }
        return value == null ? defaultValue : value.toString();
    }

    @Override
    public <T> T getProperty(String key, Class<T> clazz, T defaultValue) {
        String value = this.getProperty(key);
        return value == null ? defaultValue : this.convertValue(value, clazz);
    }

    @Override
    public boolean isActiveFeature() {
        return true;
    }

    @Override
    public String getFeatureName() {
        return "Default Properties Provider";
    }

    public static class PropertiesRoot {
        CdsProperties cds = new CdsProperties();
        PlainProperties plain = new PlainProperties();

        public CdsProperties getCds() {
            return this.cds;
        }

        public void setCds(CdsProperties cds) {
            this.cds = cds;
        }

        public PlainProperties getPlain() {
            return this.plain;
        }

        public void setPlain(PlainProperties plain) {
            this.plain = plain;
        }
    }

    private static class CustomConstructor
    extends Constructor {
        public CustomConstructor(Class<? extends Object> theRoot) {
            super(theRoot);
            this.typeDefinitions.put(Duration.class, new DurationTypeDescription());
        }

        private static class DurationTypeDescription
        extends TypeDescription {
            public DurationTypeDescription() {
                super(Duration.class);
            }

            public Object newInstance(Node node) {
                ScalarNode snode = (ScalarNode)node;
                return Duration.parse(snode.getValue());
            }
        }
    }
}

