/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.configuration;

import com.sap.cds.feature.attachments.handler.applicationservice.CreateAttachmentsHandler;
import com.sap.cds.feature.attachments.handler.applicationservice.DeleteAttachmentsHandler;
import com.sap.cds.feature.attachments.handler.applicationservice.ReadAttachmentsHandler;
import com.sap.cds.feature.attachments.handler.applicationservice.UpdateAttachmentsHandler;
import com.sap.cds.feature.attachments.handler.applicationservice.helper.ThreadLocalDataStorage;
import com.sap.cds.feature.attachments.handler.applicationservice.processor.modifyevents.CreateAttachmentEvent;
import com.sap.cds.feature.attachments.handler.applicationservice.processor.modifyevents.DefaultModifyAttachmentEventFactory;
import com.sap.cds.feature.attachments.handler.applicationservice.processor.modifyevents.DoNothingAttachmentEvent;
import com.sap.cds.feature.attachments.handler.applicationservice.processor.modifyevents.MarkAsDeletedAttachmentEvent;
import com.sap.cds.feature.attachments.handler.applicationservice.processor.modifyevents.ModifyAttachmentEvent;
import com.sap.cds.feature.attachments.handler.applicationservice.processor.modifyevents.UpdateAttachmentEvent;
import com.sap.cds.feature.attachments.handler.applicationservice.processor.readhelper.validator.DefaultAttachmentStatusValidator;
import com.sap.cds.feature.attachments.handler.applicationservice.processor.transaction.CreationChangeSetListener;
import com.sap.cds.feature.attachments.handler.applicationservice.processor.transaction.ListenerProvider;
import com.sap.cds.feature.attachments.handler.common.DefaultAssociationCascader;
import com.sap.cds.feature.attachments.handler.common.DefaultAttachmentsReader;
import com.sap.cds.feature.attachments.handler.draftservice.DraftActiveAttachmentsHandler;
import com.sap.cds.feature.attachments.handler.draftservice.DraftCancelAttachmentsHandler;
import com.sap.cds.feature.attachments.handler.draftservice.DraftPatchAttachmentsHandler;
import com.sap.cds.feature.attachments.handler.draftservice.modifier.ActiveEntityModifier;
import com.sap.cds.feature.attachments.service.AttachmentService;
import com.sap.cds.feature.attachments.service.AttachmentsServiceImpl;
import com.sap.cds.feature.attachments.service.handler.DefaultAttachmentsServiceHandler;
import com.sap.cds.feature.attachments.service.handler.transaction.EndTransactionMalwareScanProvider;
import com.sap.cds.feature.attachments.service.handler.transaction.EndTransactionMalwareScanRunner;
import com.sap.cds.feature.attachments.service.malware.DefaultAttachmentMalwareScanner;
import com.sap.cds.feature.attachments.service.malware.client.DefaultMalwareScanClient;
import com.sap.cds.feature.attachments.service.malware.client.httpclient.MalwareScanClientProviderFactory;
import com.sap.cds.feature.attachments.service.malware.client.mapper.DefaultMalwareClientStatusMapper;
import com.sap.cds.services.Service;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.environment.CdsEnvironment;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.outbox.OutboxService;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.utils.environment.ServiceBindingUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Registration
implements CdsRuntimeConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(Registration.class);

    public void services(CdsRuntimeConfigurer configurer) {
        configurer.service((Service)new AttachmentsServiceImpl());
    }

    public void eventHandlers(CdsRuntimeConfigurer configurer) {
        logger.debug("Registering event handlers");
        CdsRuntime runtime = configurer.getCdsRuntime();
        ServiceCatalog serviceCatalog = runtime.getServiceCatalog();
        CdsEnvironment environment = runtime.getEnvironment();
        PersistenceService persistenceService = (PersistenceService)serviceCatalog.getService(PersistenceService.class, "PersistenceService$Default");
        AttachmentService attachmentService = (AttachmentService)serviceCatalog.getService(AttachmentService.class, "AttachmentService$Default");
        OutboxService outbox = (OutboxService)serviceCatalog.getService(OutboxService.class, "DefaultOutboxUnordered");
        AttachmentService outboxedAttachmentService = (AttachmentService)outbox.outboxed((Service)attachmentService);
        List<ServiceBinding> bindings = environment.getServiceBindings().filter(b -> ServiceBindingUtils.matches((ServiceBinding)b, (String)"malware-scanner")).toList();
        ServiceBinding binding = !bindings.isEmpty() ? bindings.get(0) : null;
        CdsProperties.ConnectionPool connectionPool = Registration.getConnectionPool(environment);
        MalwareScanClientProviderFactory clientProviderFactory = new MalwareScanClientProviderFactory(binding, runtime, connectionPool);
        DefaultMalwareClientStatusMapper malwareStatusMapper = new DefaultMalwareClientStatusMapper();
        DefaultAttachmentMalwareScanner malwareScanner = new DefaultAttachmentMalwareScanner(persistenceService, attachmentService, new DefaultMalwareScanClient(clientProviderFactory), malwareStatusMapper, Objects.nonNull(binding));
        EndTransactionMalwareScanProvider malwareScanEndTransactionListener = (attachmentEntity, contentId) -> new EndTransactionMalwareScanRunner(attachmentEntity, contentId, malwareScanner, runtime);
        configurer.eventHandler((Object)new DefaultAttachmentsServiceHandler(malwareScanEndTransactionListener));
        MarkAsDeletedAttachmentEvent deleteContentEvent = new MarkAsDeletedAttachmentEvent(outboxedAttachmentService);
        DefaultModifyAttachmentEventFactory eventFactory = this.buildAttachmentEventFactory(attachmentService, deleteContentEvent, outboxedAttachmentService);
        DefaultAttachmentsReader attachmentsReader = new DefaultAttachmentsReader(new DefaultAssociationCascader(), persistenceService);
        ThreadLocalDataStorage storage = new ThreadLocalDataStorage();
        configurer.eventHandler((Object)new CreateAttachmentsHandler(eventFactory, storage));
        configurer.eventHandler((Object)new UpdateAttachmentsHandler(eventFactory, attachmentsReader, outboxedAttachmentService, storage));
        configurer.eventHandler((Object)new DeleteAttachmentsHandler(attachmentsReader, deleteContentEvent));
        EndTransactionMalwareScanRunner scanRunner = new EndTransactionMalwareScanRunner(null, null, malwareScanner, runtime);
        configurer.eventHandler((Object)new ReadAttachmentsHandler(attachmentService, new DefaultAttachmentStatusValidator(), scanRunner));
        configurer.eventHandler((Object)new DraftPatchAttachmentsHandler(persistenceService, eventFactory));
        configurer.eventHandler((Object)new DraftCancelAttachmentsHandler(attachmentsReader, deleteContentEvent, ActiveEntityModifier::new));
        configurer.eventHandler((Object)new DraftActiveAttachmentsHandler(storage));
    }

    private DefaultModifyAttachmentEventFactory buildAttachmentEventFactory(AttachmentService attachmentService, ModifyAttachmentEvent deleteContentEvent, AttachmentService outboxedAttachmentService) {
        ListenerProvider creationChangeSetListener = (contentId, cdsRuntime) -> new CreationChangeSetListener(contentId, cdsRuntime, outboxedAttachmentService);
        CreateAttachmentEvent createAttachmentEvent = new CreateAttachmentEvent(attachmentService, creationChangeSetListener);
        UpdateAttachmentEvent updateAttachmentEvent = new UpdateAttachmentEvent(createAttachmentEvent, deleteContentEvent);
        DoNothingAttachmentEvent doNothingAttachmentEvent = new DoNothingAttachmentEvent();
        return new DefaultModifyAttachmentEventFactory(createAttachmentEvent, updateAttachmentEvent, deleteContentEvent, doNothingAttachmentEvent);
    }

    private static CdsProperties.ConnectionPool getConnectionPool(CdsEnvironment env) {
        String prefix = "cds.attachments.malwareScanner.http.%s";
        Duration timeout = Duration.ofSeconds(((Integer)env.getProperty("cds.attachments.malwareScanner.http.%s".formatted("timeout"), Integer.class, (Object)120)).intValue());
        int maxConnections = (Integer)env.getProperty("cds.attachments.malwareScanner.http.%s".formatted("maxConnections"), Integer.class, (Object)20);
        logger.debug("Connection pool configuration: timeout={}, maxConnections={}", (Object)timeout, (Object)maxConnections);
        return new CdsProperties.ConnectionPool(timeout, Integer.valueOf(maxConnections), Integer.valueOf(maxConnections));
    }
}

