/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.applicationservice;

import com.sap.cds.CdsData;
import com.sap.cds.CdsDataProcessor;
import com.sap.cds.feature.attachments.handler.applicationservice.helper.ModifyApplicationHandlerHelper;
import com.sap.cds.feature.attachments.handler.applicationservice.helper.ReadonlyDataContextEnhancer;
import com.sap.cds.feature.attachments.handler.applicationservice.helper.ThreadDataStorageReader;
import com.sap.cds.feature.attachments.handler.applicationservice.processor.modifyevents.ModifyAttachmentEventFactory;
import com.sap.cds.feature.attachments.handler.common.ApplicationHandlerHelper;
import com.sap.cds.feature.attachments.utilities.LoggingMarker;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.CdsCreateEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class CreateAttachmentsHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateAttachmentsHandler.class);
    private static final Marker marker = LoggingMarker.APPLICATION_HANDLER.getMarker();
    private final ModifyAttachmentEventFactory eventFactory;
    private final ThreadDataStorageReader storageReader;
    private final CdsDataProcessor processor = CdsDataProcessor.create();

    public CreateAttachmentsHandler(ModifyAttachmentEventFactory eventFactory, ThreadDataStorageReader storageReader) {
        this.eventFactory = eventFactory;
        this.storageReader = storageReader;
    }

    @Before
    @HandlerOrder(value=-10800)
    public void processBeforeForDraft(CdsCreateEventContext context, List<CdsData> data) {
        ReadonlyDataContextEnhancer.enhanceReadonlyDataInContext((EventContext)context, data, this.storageReader.get());
    }

    @Before
    @HandlerOrder(value=10000)
    public void processBefore(CdsCreateEventContext context, List<CdsData> data) {
        this.doCreate(context, data);
    }

    private void doCreate(CdsCreateEventContext context, List<CdsData> data) {
        if (ApplicationHandlerHelper.noContentFieldInData(context.getTarget(), data)) {
            return;
        }
        logger.debug(marker, "Processing before create event for entity {}", (Object)context.getTarget().getName());
        this.setKeysInData(context.getTarget(), data);
        ModifyApplicationHandlerHelper.handleAttachmentForEntities(context.getTarget(), data, new ArrayList<CdsData>(), this.eventFactory, (EventContext)context);
    }

    private void setKeysInData(CdsEntity entity, List<CdsData> data) {
        this.processor.addGenerator((path, element, type) -> element.isKey() && element.getType().isSimpleType(CdsBaseType.UUID), (path, element, isNull) -> UUID.randomUUID().toString()).process(data, (CdsStructuredType)entity);
    }
}

