/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.applicationservice;

import com.sap.cds.CdsData;
import com.sap.cds.CdsDataProcessor;
import com.sap.cds.feature.attachments.handler.applicationservice.processor.modifyevents.ModifyAttachmentEvent;
import com.sap.cds.feature.attachments.handler.common.ApplicationHandlerHelper;
import com.sap.cds.feature.attachments.handler.common.AttachmentsReader;
import com.sap.cds.feature.attachments.utilities.LoggingMarker;
import com.sap.cds.ql.cqn.CqnFilterableStatement;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.CdsDeleteEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class DeleteAttachmentsHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeleteAttachmentsHandler.class);
    private static final Marker marker = LoggingMarker.APPLICATION_HANDLER.getMarker();
    private final AttachmentsReader attachmentsReader;
    private final ModifyAttachmentEvent deleteContentAttachmentEvent;

    public DeleteAttachmentsHandler(AttachmentsReader attachmentsReader, ModifyAttachmentEvent deleteContentAttachmentEvent) {
        this.attachmentsReader = attachmentsReader;
        this.deleteContentAttachmentEvent = deleteContentAttachmentEvent;
    }

    @Before
    @HandlerOrder(value=10000)
    public void processBefore(CdsDeleteEventContext context) {
        logger.debug(marker, "Processing before delete event for entity {}", (Object)context.getTarget().getName());
        List<CdsData> attachments = this.attachmentsReader.readAttachments(context.getModel(), context.getTarget(), (CqnFilterableStatement)context.getCqn());
        CdsDataProcessor.Converter converter = (path, element, value) -> this.deleteContentAttachmentEvent.processEvent(path, (InputStream)value, CdsData.create((Map)path.target().values()), (EventContext)context);
        ApplicationHandlerHelper.callProcessor(context.getTarget(), attachments, ApplicationHandlerHelper.MEDIA_CONTENT_FILTER, converter);
    }
}

