/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.applicationservice;

import com.sap.cds.CdsData;
import com.sap.cds.CdsDataProcessor;
import com.sap.cds.feature.attachments.handler.applicationservice.processor.readhelper.modifier.BeforeReadItemsModifier;
import com.sap.cds.feature.attachments.handler.applicationservice.processor.readhelper.stream.LazyProxyInputStream;
import com.sap.cds.feature.attachments.handler.applicationservice.processor.readhelper.validator.AttachmentStatusValidator;
import com.sap.cds.feature.attachments.handler.common.ApplicationHandlerHelper;
import com.sap.cds.feature.attachments.service.AttachmentService;
import com.sap.cds.feature.attachments.service.malware.AsyncMalwareScanExecutor;
import com.sap.cds.feature.attachments.utilities.LoggingMarker;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElementDefinition;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class ReadAttachmentsHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(ReadAttachmentsHandler.class);
    private static final Marker marker = LoggingMarker.APPLICATION_HANDLER.getMarker();
    private final AttachmentService attachmentService;
    private final AttachmentStatusValidator attachmentStatusValidator;
    private final AsyncMalwareScanExecutor asyncMalwareScanExecutor;

    public ReadAttachmentsHandler(AttachmentService attachmentService, AttachmentStatusValidator attachmentStatusValidator, AsyncMalwareScanExecutor asyncMalwareScanExecutor) {
        this.attachmentService = attachmentService;
        this.attachmentStatusValidator = attachmentStatusValidator;
        this.asyncMalwareScanExecutor = asyncMalwareScanExecutor;
    }

    @Before
    @HandlerOrder(value=-10000)
    public void processBefore(CdsReadEventContext context) {
        logger.debug(marker, "Processing before read event for entity {}", (Object)context.getTarget().getName());
        CdsModel cdsModel = context.getModel();
        List<String> fieldNames = this.getAttachmentAssociations(cdsModel, context.getTarget(), "", new ArrayList<String>());
        if (!fieldNames.isEmpty()) {
            CqnSelect resultCqn = (CqnSelect)CQL.copy((CqnStatement)context.getCqn(), (Modifier)new BeforeReadItemsModifier(fieldNames));
            context.setCqn(resultCqn);
        }
    }

    @After
    @HandlerOrder(value=-10000)
    public void processAfter(CdsReadEventContext context, List<CdsData> data) {
        if (ApplicationHandlerHelper.noContentFieldInData(context.getTarget(), data)) {
            return;
        }
        logger.debug(marker, "Processing after read event for entity {}", (Object)context.getTarget().getName());
        CdsDataProcessor.Converter converter = (path, element, value) -> {
            logger.info(marker, "Processing after read event for entity {}", (Object)element.getName());
            String contentId = (String)path.target().values().get("contentId");
            String status = (String)path.target().values().get("status");
            InputStream content = (InputStream)path.target().values().get("content");
            boolean contentExists = Objects.nonNull(content);
            if (Objects.nonNull(contentId) || contentExists) {
                this.verifyStatus(path, status, contentId, contentExists);
                Supplier<InputStream> supplier = Objects.nonNull(content) ? () -> content : () -> this.attachmentService.readAttachment(contentId);
                return new LazyProxyInputStream(supplier, this.attachmentStatusValidator, status);
            }
            return value;
        };
        ApplicationHandlerHelper.callProcessor(context.getTarget(), data, ApplicationHandlerHelper.MEDIA_CONTENT_FILTER, converter);
    }

    private List<String> getAttachmentAssociations(CdsModel model, CdsEntity entity, String associationName, List<String> processedEntities) {
        Map<String, CdsEntity> annotatedEntitiesMap;
        ArrayList<String> associationNames = new ArrayList<String>();
        if (ApplicationHandlerHelper.isMediaEntity((CdsStructuredType)entity)) {
            associationNames.add(associationName);
        }
        if ((annotatedEntitiesMap = entity.associations().collect(Collectors.toMap(CdsElementDefinition::getName, element -> ((CdsAssociationType)element.getType().as(CdsAssociationType.class)).getTarget()))).isEmpty()) {
            return associationNames;
        }
        for (Map.Entry<String, CdsEntity> associatedElement : annotatedEntitiesMap.entrySet()) {
            if (associationNames.contains(associatedElement.getKey()) || processedEntities.contains(associatedElement.getKey()) || "SiblingEntity".equals(associatedElement.getKey())) continue;
            processedEntities.add(associatedElement.getKey());
            List<String> result = this.getAttachmentAssociations(model, associatedElement.getValue(), associatedElement.getKey(), processedEntities);
            associationNames.addAll(result);
        }
        return associationNames;
    }

    private void verifyStatus(Path path, String status, String contentId, boolean contentExists) {
        if (this.areKeysEmpty(path.target().keys())) {
            logger.info(marker, "In verify status for content id {} and status {}", (Object)contentId, (Object)status);
            if (("Unscanned".equals(status) || "Scanning".equals(status)) && contentExists) {
                logger.info(marker, "Scanning content with ID {} for malware, has current status {}", (Object)contentId, (Object)status);
                this.asyncMalwareScanExecutor.scanAsync(path.target().entity(), contentId);
            }
            this.attachmentStatusValidator.verifyStatus(status);
        }
    }

    private boolean areKeysEmpty(Map<String, Object> keys) {
        return keys.values().stream().allMatch(Objects::isNull);
    }
}

