/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.applicationservice;

import com.sap.cds.CdsData;
import com.sap.cds.CdsDataProcessor;
import com.sap.cds.feature.attachments.handler.applicationservice.helper.ModifyApplicationHandlerHelper;
import com.sap.cds.feature.attachments.handler.applicationservice.helper.ReadonlyDataContextEnhancer;
import com.sap.cds.feature.attachments.handler.applicationservice.helper.ThreadDataStorageReader;
import com.sap.cds.feature.attachments.handler.applicationservice.processor.modifyevents.ModifyAttachmentEventFactory;
import com.sap.cds.feature.attachments.handler.common.ApplicationHandlerHelper;
import com.sap.cds.feature.attachments.handler.common.AttachmentsReader;
import com.sap.cds.feature.attachments.service.AttachmentService;
import com.sap.cds.feature.attachments.service.model.service.MarkAsDeletedInput;
import com.sap.cds.feature.attachments.utilities.LoggingMarker;
import com.sap.cds.ql.cqn.CqnFilterableStatement;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.CdsUpdateEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.utils.model.CqnUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class UpdateAttachmentsHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdateAttachmentsHandler.class);
    private static final Marker marker = LoggingMarker.APPLICATION_HANDLER.getMarker();
    private final ModifyAttachmentEventFactory eventFactory;
    private final AttachmentsReader attachmentsReader;
    private final AttachmentService outboxedAttachmentService;
    private final ThreadDataStorageReader storageReader;

    public UpdateAttachmentsHandler(ModifyAttachmentEventFactory eventFactory, AttachmentsReader attachmentsReader, AttachmentService outboxedAttachmentService, ThreadDataStorageReader storageReader) {
        this.eventFactory = eventFactory;
        this.attachmentsReader = attachmentsReader;
        this.outboxedAttachmentService = outboxedAttachmentService;
        this.storageReader = storageReader;
    }

    @Before
    @HandlerOrder(value=-10800)
    public void processBeforeForDraft(CdsUpdateEventContext context, List<CdsData> data) {
        ReadonlyDataContextEnhancer.enhanceReadonlyDataInContext((EventContext)context, data, this.storageReader.get());
    }

    @Before
    @HandlerOrder(value=10000)
    public void processBefore(CdsUpdateEventContext context, List<CdsData> data) {
        this.doUpdate(context, data);
    }

    private void doUpdate(CdsUpdateEventContext context, List<CdsData> data) {
        CdsEntity target = context.getTarget();
        boolean noContentInData = ApplicationHandlerHelper.noContentFieldInData(target, data);
        boolean associationsAreUnchanged = this.associationsAreUnchanged(target, data);
        if (noContentInData && associationsAreUnchanged) {
            return;
        }
        logger.debug(marker, "Processing before update event for entity {}", (Object)target.getName());
        CqnFilterableStatement select = this.getSelect(context.getCqn(), context.getTarget());
        List<CdsData> attachments = this.attachmentsReader.readAttachments(context.getModel(), target, select);
        List<CdsData> condensedAttachments = ApplicationHandlerHelper.condenseData(attachments, target);
        ModifyApplicationHandlerHelper.handleAttachmentForEntities(target, data, condensedAttachments, this.eventFactory, (EventContext)context);
        if (!associationsAreUnchanged) {
            this.deleteRemovedAttachments(attachments, data, target, context.getUserInfo());
        }
    }

    private boolean associationsAreUnchanged(CdsEntity entity, List<CdsData> data) {
        return entity.compositions().noneMatch(association -> data.stream().anyMatch(d -> d.containsKey((Object)association.getName())));
    }

    private CqnFilterableStatement getSelect(CqnUpdate update, CdsEntity target) {
        return CqnUtils.toSelect((CqnUpdate)update, (CdsEntity)target);
    }

    private void deleteRemovedAttachments(List<CdsData> exitingDataList, List<CdsData> updatedDataList, CdsEntity entity, UserInfo userInfo) {
        List<CdsData> condensedUpdatedData = ApplicationHandlerHelper.condenseData(updatedDataList, entity);
        CdsDataProcessor.Validator validator = (path, element, value) -> {
            Map<String, Object> keys = ApplicationHandlerHelper.removeDraftKeys(path.target().keys());
            boolean entryExists = condensedUpdatedData.stream().anyMatch(updatedData -> ApplicationHandlerHelper.areKeysInData(keys, updatedData));
            if (!entryExists) {
                String contentId = (String)path.target().values().get("contentId");
                this.outboxedAttachmentService.markAttachmentAsDeleted(new MarkAsDeletedInput(contentId, userInfo));
            }
        };
        ApplicationHandlerHelper.callValidator(entity, exitingDataList, ApplicationHandlerHelper.MEDIA_CONTENT_FILTER, validator);
    }
}

