/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.applicationservice.helper;

import com.sap.cds.CdsData;
import com.sap.cds.CdsDataProcessor;
import com.sap.cds.feature.attachments.handler.common.ApplicationHandlerHelper;
import com.sap.cds.services.EventContext;
import java.util.List;
import java.util.Objects;

public final class ReadonlyDataContextEnhancer {
    private static final String DRAFT_READONLY_CONTEXT = "DRAFT_READONLY_CONTEXT";

    private ReadonlyDataContextEnhancer() {
    }

    public static void enhanceReadonlyDataInContext(EventContext context, List<CdsData> data, boolean isDraft) {
        CdsDataProcessor.Validator validator = (path, element, value) -> {
            if (isDraft) {
                Object contentId = path.target().values().get("contentId");
                Object statusCode = path.target().values().get("status");
                Object scannedAt = path.target().values().get("scannedAt");
                CdsData cdsData = CdsData.create();
                cdsData.put((Object)"contentId", contentId);
                cdsData.put((Object)"status", statusCode);
                cdsData.put((Object)"scannedAt", scannedAt);
                path.target().values().put(DRAFT_READONLY_CONTEXT, cdsData);
            } else {
                path.target().values().remove(DRAFT_READONLY_CONTEXT);
            }
        };
        ApplicationHandlerHelper.callValidator(context.getTarget(), data, ApplicationHandlerHelper.MEDIA_CONTENT_FILTER, validator);
    }

    public static void fillReadonlyInContext(CdsData data) {
        CdsData readOnlyData = (CdsData)data.get((Object)DRAFT_READONLY_CONTEXT);
        if (Objects.nonNull(readOnlyData)) {
            data.put((Object)"contentId", readOnlyData.get((Object)"contentId"));
            data.put((Object)"status", readOnlyData.get((Object)"status"));
            data.put((Object)"scannedAt", readOnlyData.get((Object)"scannedAt"));
            data.remove((Object)DRAFT_READONLY_CONTEXT);
        }
    }
}

