/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.applicationservice.processor.modifyevents;

import com.sap.cds.CdsData;
import com.sap.cds.feature.attachments.handler.applicationservice.processor.modifyevents.ModifyAttachmentEvent;
import com.sap.cds.feature.attachments.handler.applicationservice.processor.transaction.ListenerProvider;
import com.sap.cds.feature.attachments.handler.common.ApplicationHandlerHelper;
import com.sap.cds.feature.attachments.service.AttachmentService;
import com.sap.cds.feature.attachments.service.model.service.AttachmentModificationResult;
import com.sap.cds.feature.attachments.service.model.service.CreateAttachmentInput;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.changeset.ChangeSetContext;
import com.sap.cds.services.changeset.ChangeSetListener;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateAttachmentEvent
implements ModifyAttachmentEvent {
    private static final Logger logger = LoggerFactory.getLogger(CreateAttachmentEvent.class);
    private final AttachmentService attachmentService;
    private final ListenerProvider listenerProvider;

    public CreateAttachmentEvent(AttachmentService attachmentService, ListenerProvider listenerProvider) {
        this.attachmentService = attachmentService;
        this.listenerProvider = listenerProvider;
    }

    private static Optional<String> getFieldValue(String fieldName, Map<String, Object> values, CdsData existingData) {
        Object annotationValue = values.get(fieldName);
        Object value = Objects.nonNull(annotationValue) ? annotationValue : existingData.get((Object)fieldName);
        return Optional.ofNullable((String)value);
    }

    @Override
    public InputStream processEvent(Path path, InputStream content, CdsData existingData, EventContext eventContext) {
        logger.debug("Calling attachment service with create event for entity {}", (Object)path.target().entity().getQualifiedName());
        Map values = path.target().values();
        Map<String, Object> keys = ApplicationHandlerHelper.removeDraftKeys(path.target().keys());
        Optional<String> mimeTypeOptional = CreateAttachmentEvent.getFieldValue("mimeType", values, existingData);
        Optional<String> fileNameOptional = CreateAttachmentEvent.getFieldValue("fileName", values, existingData);
        CreateAttachmentInput createEventInput = new CreateAttachmentInput(keys, path.target().entity(), fileNameOptional.orElse(null), mimeTypeOptional.orElse(null), content);
        AttachmentModificationResult result = this.attachmentService.createAttachment(createEventInput);
        ChangeSetListener createListener = this.listenerProvider.provideListener(result.contentId(), eventContext.getCdsRuntime());
        ChangeSetContext context = eventContext.getChangeSetContext();
        context.register(createListener);
        path.target().values().put("contentId", result.contentId());
        path.target().values().put("status", result.status());
        return result.isInternalStored() ? content : null;
    }
}

