/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.applicationservice.processor.modifyevents;

import com.sap.cds.CdsData;
import com.sap.cds.feature.attachments.handler.applicationservice.processor.modifyevents.ModifyAttachmentEvent;
import com.sap.cds.feature.attachments.handler.applicationservice.processor.modifyevents.ModifyAttachmentEventFactory;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;

public class DefaultModifyAttachmentEventFactory
implements ModifyAttachmentEventFactory {
    private final ModifyAttachmentEvent createEvent;
    private final ModifyAttachmentEvent updateEvent;
    private final ModifyAttachmentEvent deleteContentEvent;
    private final ModifyAttachmentEvent doNothingEvent;

    public DefaultModifyAttachmentEventFactory(ModifyAttachmentEvent createEvent, ModifyAttachmentEvent updateEvent, ModifyAttachmentEvent deleteContentEvent, ModifyAttachmentEvent doNothingEvent) {
        this.createEvent = createEvent;
        this.updateEvent = updateEvent;
        this.deleteContentEvent = deleteContentEvent;
        this.doNothingEvent = doNothingEvent;
    }

    @Override
    public ModifyAttachmentEvent getEvent(InputStream content, String contentId, CdsData existingData) {
        Object existingContentId = existingData.get((Object)"contentId");
        Optional<ModifyAttachmentEvent> event = contentId != null ? this.handleExistingContentId(content, contentId, (String)existingContentId) : this.handleNonExistingContentId(content, existingContentId);
        return event.orElse(this.doNothingEvent);
    }

    private Optional<ModifyAttachmentEvent> handleExistingContentId(InputStream content, String contentId, String existingContentId) {
        ModifyAttachmentEvent event = null;
        if (contentId.equals(existingContentId) && Objects.nonNull(content)) {
            event = this.updateEvent;
        }
        if (Objects.nonNull(existingContentId) && !contentId.equals(existingContentId) && Objects.isNull(content)) {
            event = this.deleteContentEvent;
        }
        if (Objects.nonNull(existingContentId) && !contentId.equals(existingContentId) && Objects.nonNull(content)) {
            event = this.updateEvent;
        }
        return Optional.ofNullable(event);
    }

    private Optional<ModifyAttachmentEvent> handleNonExistingContentId(Object content, Object existingContentId) {
        ModifyAttachmentEvent event = null;
        if (Objects.nonNull(existingContentId)) {
            event = Objects.nonNull(content) ? this.updateEvent : this.deleteContentEvent;
        } else if (Objects.nonNull(content)) {
            event = this.createEvent;
        }
        return Optional.ofNullable(event);
    }
}

