/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.applicationservice.processor.modifyevents;

import com.sap.cds.CdsData;
import com.sap.cds.feature.attachments.handler.applicationservice.processor.modifyevents.ModifyAttachmentEvent;
import com.sap.cds.feature.attachments.handler.common.ApplicationHandlerHelper;
import com.sap.cds.feature.attachments.service.AttachmentService;
import com.sap.cds.feature.attachments.service.model.service.MarkAsDeletedInput;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.services.EventContext;
import java.io.InputStream;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkAsDeletedAttachmentEvent
implements ModifyAttachmentEvent {
    private static final Logger logger = LoggerFactory.getLogger(MarkAsDeletedAttachmentEvent.class);
    private final AttachmentService outboxedAttachmentService;

    public MarkAsDeletedAttachmentEvent(AttachmentService outboxedAttachmentService) {
        this.outboxedAttachmentService = outboxedAttachmentService;
    }

    @Override
    public InputStream processEvent(Path path, InputStream content, CdsData existingData, EventContext eventContext) {
        Object newContentId;
        String qualifiedName = eventContext.getTarget().getQualifiedName();
        logger.debug("Processing the event for calling attachment service with mark as delete event for entity {}", (Object)qualifiedName);
        if (ApplicationHandlerHelper.doesContentIdExistsBefore(existingData) && !"DRAFT_PATCH".equals(eventContext.getEvent())) {
            logger.debug("Calling attachment service with mark as delete event for entity {}", (Object)qualifiedName);
            String contentId = (String)existingData.get((Object)"contentId");
            this.outboxedAttachmentService.markAttachmentAsDeleted(new MarkAsDeletedInput(contentId, eventContext.getUserInfo()));
        } else {
            logger.debug("Do NOT call attachment service with mark as delete event for entity {} as no document id found in existing data and event is DRAFT_PATCH event", (Object)qualifiedName);
        }
        if (Objects.nonNull(path) && (Objects.nonNull(newContentId = path.target().values().get("contentId")) && newContentId.equals(existingData.get((Object)"contentId")) || !path.target().values().containsKey("contentId"))) {
            path.target().values().put("contentId", null);
            path.target().values().put("status", null);
            path.target().values().put("scannedAt", null);
        }
        return content;
    }
}

