/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.applicationservice.processor.readhelper.stream;

import com.sap.cds.feature.attachments.handler.applicationservice.processor.readhelper.validator.AttachmentStatusValidator;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyProxyInputStream
extends InputStream {
    private static final Logger logger = LoggerFactory.getLogger(LazyProxyInputStream.class);
    private final Supplier<InputStream> inputStreamSupplier;
    private final AttachmentStatusValidator attachmentStatusValidator;
    private final String status;
    private InputStream delegate;

    public LazyProxyInputStream(Supplier<InputStream> inputStreamSupplier, AttachmentStatusValidator attachmentStatusValidator, String status) {
        this.inputStreamSupplier = inputStreamSupplier;
        this.attachmentStatusValidator = attachmentStatusValidator;
        this.status = status;
    }

    @Override
    public int read() throws IOException {
        logger.debug("Reading from input stream");
        return this.getDelegate().read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        logger.debug("Reading byte from input stream");
        return this.getDelegate().read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        logger.debug("Reading byte with off and len from input stream");
        return this.getDelegate().read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        logger.debug("Closing input stream");
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    private InputStream getDelegate() {
        this.attachmentStatusValidator.verifyStatus(this.status);
        if (this.delegate == null) {
            logger.debug("Creating delegate input stream");
            this.delegate = this.inputStreamSupplier.get();
        }
        return this.delegate;
    }
}

