/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.common;

import com.sap.cds.CdsData;
import com.sap.cds.CdsDataProcessor;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ApplicationHandlerHelper {
    public static final CdsDataProcessor.Filter MEDIA_CONTENT_FILTER = (path, element, type) -> ApplicationHandlerHelper.isMediaEntity(path.target().type()) && ApplicationHandlerHelper.hasElementAnnotation(element, "Core.MediaType");

    public static boolean noContentFieldInData(CdsEntity entity, List<CdsData> data) {
        AtomicBoolean isIncluded = new AtomicBoolean();
        CdsDataProcessor.Validator validator = (path, element, value) -> isIncluded.set(true);
        ApplicationHandlerHelper.callValidator(entity, data, MEDIA_CONTENT_FILTER, validator);
        return !isIncluded.get();
    }

    public static void callProcessor(CdsEntity entity, List<CdsData> data, CdsDataProcessor.Filter filter, CdsDataProcessor.Converter converter) {
        CdsDataProcessor.create().addConverter(filter, converter).process(data, (CdsStructuredType)entity);
    }

    public static void callValidator(CdsEntity entity, List<CdsData> data, CdsDataProcessor.Filter filter, CdsDataProcessor.Validator validator) {
        CdsDataProcessor.create().addValidator(filter, validator).process(data, (CdsStructuredType)entity);
    }

    public static boolean isMediaEntity(CdsStructuredType baseEntity) {
        return (Boolean)baseEntity.getAnnotationValue("_is_media_data", (Object)false);
    }

    public static boolean doesContentIdExistsBefore(Map<?, Object> existingData) {
        return Objects.nonNull(existingData.get("contentId"));
    }

    public static List<CdsData> condenseData(List<CdsData> data, CdsEntity entity) {
        ArrayList<CdsData> resultList = new ArrayList<CdsData>();
        CdsDataProcessor.Validator validator = (path, element, value) -> resultList.add(CdsData.create((Map)path.target().values()));
        ApplicationHandlerHelper.callValidator(entity, data, MEDIA_CONTENT_FILTER, validator);
        return resultList;
    }

    public static boolean areKeysInData(Map<String, Object> keys, CdsData data) {
        return keys.entrySet().stream().allMatch(entry -> {
            Object keyInData = data.get(entry.getKey());
            return Objects.nonNull(keyInData) && keyInData.equals(entry.getValue());
        });
    }

    public static Map<String, Object> removeDraftKeys(Map<String, Object> keys) {
        HashMap<String, Object> keyMap = new HashMap<String, Object>(keys);
        keyMap.entrySet().removeIf(entry -> ApplicationHandlerHelper.isDraftActiveEntityField((String)entry.getKey()));
        return keyMap;
    }

    private static boolean hasElementAnnotation(CdsElement element, String annotation) {
        return element.findAnnotation(annotation).isPresent();
    }

    private static boolean isDraftActiveEntityField(String key) {
        return key.equals("IsActiveEntity");
    }

    private ApplicationHandlerHelper() {
    }
}

