/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.common;

import com.sap.cds.feature.attachments.handler.common.ApplicationHandlerHelper;
import com.sap.cds.feature.attachments.handler.common.AssociationCascader;
import com.sap.cds.feature.attachments.handler.common.model.AssociationIdentifier;
import com.sap.cds.feature.attachments.handler.common.model.NodeTree;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElementDefinition;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAssociationCascader
implements AssociationCascader {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAssociationCascader.class);

    @Override
    public NodeTree findEntityPath(CdsModel model, CdsEntity entity) {
        logger.debug("Start finding path to attachments for entity {}", (Object)entity.getQualifiedName());
        LinkedList<AssociationIdentifier> firstList = new LinkedList<AssociationIdentifier>();
        List<LinkedList<AssociationIdentifier>> internalResultList = this.getAttachmentAssociationPath(model, entity, "", firstList, new ArrayList<String>(List.of(entity.getQualifiedName())));
        NodeTree rootTree = new NodeTree(new AssociationIdentifier("", entity.getQualifiedName()));
        internalResultList.forEach(rootTree::addPath);
        logger.debug("Found path to attachments for entity {}: {}", (Object)entity.getQualifiedName(), (Object)rootTree);
        return rootTree;
    }

    private List<LinkedList<AssociationIdentifier>> getAttachmentAssociationPath(CdsModel model, CdsEntity entity, String associationName, LinkedList<AssociationIdentifier> firstList, List<String> processedEntities) {
        ArrayList<LinkedList<AssociationIdentifier>> internalResultList = new ArrayList<LinkedList<AssociationIdentifier>>();
        AtomicReference currentList = new AtomicReference();
        ArrayList<String> localProcessEntities = new ArrayList<String>();
        currentList.set(new LinkedList());
        boolean isMediaEntity = ApplicationHandlerHelper.isMediaEntity((CdsStructuredType)entity);
        if (isMediaEntity) {
            AssociationIdentifier identifier = new AssociationIdentifier(associationName, entity.getQualifiedName());
            firstList.addLast(identifier);
        }
        if (isMediaEntity) {
            internalResultList.add(firstList);
            return internalResultList;
        }
        Map<String, CdsEntity> associations = entity.elements().filter(element -> element.getType().isAssociation() && ((CdsAssociationType)element.getType().as(CdsAssociationType.class)).isComposition()).collect(Collectors.toMap(CdsElementDefinition::getName, element -> ((CdsAssociationType)element.getType().as(CdsAssociationType.class)).getTarget()));
        if (associations.isEmpty()) {
            return internalResultList;
        }
        boolean newListNeeded = false;
        for (Map.Entry<String, CdsEntity> associatedElement : associations.entrySet()) {
            if (processedEntities.contains(associatedElement.getValue().getQualifiedName())) continue;
            if (newListNeeded) {
                currentList.set(new LinkedList());
                ((LinkedList)currentList.get()).addAll(firstList);
                processedEntities = localProcessEntities;
            } else {
                firstList.add(new AssociationIdentifier(associationName, entity.getQualifiedName()));
                ((LinkedList)currentList.get()).addAll(firstList);
                localProcessEntities = new ArrayList<String>(processedEntities);
            }
            processedEntities.add(associatedElement.getValue().getQualifiedName());
            newListNeeded = true;
            List<LinkedList<AssociationIdentifier>> result = this.getAttachmentAssociationPath(model, associatedElement.getValue(), associatedElement.getKey(), (LinkedList)currentList.get(), processedEntities);
            internalResultList.addAll(result);
        }
        return internalResultList;
    }
}

