/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.common;

import com.sap.cds.CdsData;
import com.sap.cds.Result;
import com.sap.cds.feature.attachments.handler.common.AssociationCascader;
import com.sap.cds.feature.attachments.handler.common.AttachmentsReader;
import com.sap.cds.feature.attachments.handler.common.model.NodeTree;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Expand;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnFilterableStatement;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.persistence.PersistenceService;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAttachmentsReader
implements AttachmentsReader {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAttachmentsReader.class);
    private final AssociationCascader cascader;
    private final PersistenceService persistence;

    public DefaultAttachmentsReader(AssociationCascader cascader, PersistenceService persistence) {
        this.cascader = cascader;
        this.persistence = persistence;
    }

    @Override
    public List<CdsData> readAttachments(CdsModel model, CdsEntity entity, CqnFilterableStatement statement) {
        logger.debug("Start reading attachments for entity {}", (Object)entity.getQualifiedName());
        NodeTree nodePath = this.cascader.findEntityPath(model, entity);
        List<Expand<?>> expandList = this.buildExpandList(nodePath);
        Select select = !expandList.isEmpty() ? Select.from((CqnStructuredTypeRef)statement.ref()).columns(expandList) : Select.from((CqnStructuredTypeRef)statement.ref()).columns(new Function[]{StructuredType::_all});
        statement.where().ifPresent(arg_0 -> ((Select)select).where(arg_0));
        Result result = this.persistence.run((CqnSelect)select, new Object[0]);
        List cdsData = result.listOf(CdsData.class);
        this.logResultData(entity, cdsData);
        return cdsData;
    }

    private List<Expand<?>> buildExpandList(NodeTree root) {
        ArrayList expandResultList = new ArrayList();
        root.getChildren().forEach(child -> expandResultList.add(this.buildExpandFromTree((NodeTree)child)));
        return expandResultList;
    }

    private Expand<?> buildExpandFromTree(NodeTree node) {
        return node.getChildren().isEmpty() ? CQL.to((String)node.getIdentifier().associationName()).expand() : CQL.to((String)node.getIdentifier().associationName()).expand(node.getChildren().stream().map(this::buildExpandFromTree).toList());
    }

    private void logResultData(CdsEntity entity, List<CdsData> cdsData) {
        logger.debug("Read attachments for entity {}: lines {}", (Object)entity.getQualifiedName(), (Object)cdsData.size());
        if (logger.isTraceEnabled()) {
            cdsData.forEach(data -> logger.trace("Read attachment data: {}", data));
        }
    }
}

