/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.common.model;

import com.sap.cds.feature.attachments.handler.common.model.AssociationIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class NodeTree {
    private final AssociationIdentifier identifier;
    private final List<NodeTree> children = new ArrayList<NodeTree>();

    public NodeTree(AssociationIdentifier identifier) {
        this.identifier = identifier;
    }

    public void addPath(List<AssociationIdentifier> path) {
        Optional<AssociationIdentifier> currentIdentifierOptional = path.stream().filter(entry -> entry.fullEntityName().equals(this.identifier.fullEntityName())).findAny();
        if (currentIdentifierOptional.isEmpty()) {
            return;
        }
        NodeTree currentNode = this;
        int index = path.indexOf(currentIdentifierOptional.get());
        if (index == path.size() - 1) {
            return;
        }
        for (int i = index + 1; i < path.size(); ++i) {
            AssociationIdentifier pathEntry = path.get(i);
            currentNode = currentNode.getChildOrNew(pathEntry);
        }
    }

    public NodeTree getChildOrNew(AssociationIdentifier identifier) {
        Optional<NodeTree> childOptional = this.children.stream().filter(child -> child.identifier.fullEntityName().equals(identifier.fullEntityName())).findAny();
        if (childOptional.isPresent()) {
            return childOptional.get();
        }
        NodeTree child2 = new NodeTree(identifier);
        this.children.add(child2);
        return child2;
    }

    public AssociationIdentifier getIdentifier() {
        return this.identifier;
    }

    public List<NodeTree> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public String toString() {
        return "NodeTree{identifier=" + this.identifier + ", children=" + this.children + "}";
    }
}

