/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.draftservice;

import com.sap.cds.CdsData;
import com.sap.cds.CdsDataProcessor;
import com.sap.cds.feature.attachments.handler.applicationservice.processor.modifyevents.ModifyAttachmentEvent;
import com.sap.cds.feature.attachments.handler.common.ApplicationHandlerHelper;
import com.sap.cds.feature.attachments.handler.common.AttachmentsReader;
import com.sap.cds.feature.attachments.handler.draftservice.modifier.ActiveEntityModifierProvider;
import com.sap.cds.feature.attachments.utilities.LoggingMarker;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnFilterableStatement;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.draft.DraftCancelEventContext;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

@ServiceName(value={"*"}, type={DraftService.class})
public class DraftCancelAttachmentsHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(DraftCancelAttachmentsHandler.class);
    private static final Marker marker = LoggingMarker.DRAFT_HANDLER.getMarker();
    private final AttachmentsReader attachmentsReader;
    private final ModifyAttachmentEvent deleteContentAttachmentEvent;
    private final ActiveEntityModifierProvider activeEntityModifierProvider;

    public DraftCancelAttachmentsHandler(AttachmentsReader attachmentsReader, ModifyAttachmentEvent deleteContentAttachmentEvent, ActiveEntityModifierProvider activeEntityModifierProvider) {
        this.attachmentsReader = attachmentsReader;
        this.deleteContentAttachmentEvent = deleteContentAttachmentEvent;
        this.activeEntityModifierProvider = activeEntityModifierProvider;
    }

    @Before
    @HandlerOrder(value=10000)
    public void processBeforeDraftCancel(DraftCancelEventContext context) {
        if (this.isWhereEmpty(context)) {
            logger.debug(marker, "Processing before draft cancel event for entity {}", (Object)context.getTarget().getName());
            CdsStructuredType activeEntity = this.getActiveEntity(context);
            CdsStructuredType draftEntity = this.getDraftEntity(context);
            List<CdsData> draftAttachments = this.readAttachments(context, draftEntity, false);
            List<CdsData> activeCondensedAttachments = this.getCondensedActiveAttachments(context, activeEntity);
            CdsDataProcessor.Filter filter = this.buildContentIdFilter();
            CdsDataProcessor.Validator validator = this.buildDeleteContentValidator(context, activeCondensedAttachments);
            ApplicationHandlerHelper.callValidator(context.getTarget(), draftAttachments, filter, validator);
        }
    }

    private CdsDataProcessor.Validator buildDeleteContentValidator(DraftCancelEventContext context, List<CdsData> activeCondensedAttachments) {
        return (path, element, value) -> {
            if (Boolean.FALSE.equals(path.target().values().get("HasActiveEntity"))) {
                this.deleteContentAttachmentEvent.processEvent(path, null, CdsData.create((Map)path.target().values()), (EventContext)context);
                return;
            }
            Map<String, Object> keys = ApplicationHandlerHelper.removeDraftKeys(path.target().keys());
            Optional<CdsData> existingEntry = activeCondensedAttachments.stream().filter(updatedData -> ApplicationHandlerHelper.areKeysInData(keys, updatedData)).findAny();
            existingEntry.ifPresent(entry -> {
                if (!entry.get((Object)"contentId").equals(value)) {
                    this.deleteContentAttachmentEvent.processEvent(null, null, CdsData.create((Map)path.target().values()), (EventContext)context);
                }
            });
        };
    }

    private boolean isWhereEmpty(DraftCancelEventContext context) {
        return context.getCqn().where().isEmpty();
    }

    private CdsStructuredType getActiveEntity(DraftCancelEventContext context) {
        return this.isDraftEntity(context) ? context.getTarget().getTargetOf("SiblingEntity") : context.getTarget();
    }

    private CdsStructuredType getDraftEntity(DraftCancelEventContext context) {
        return this.isDraftEntity(context) ? context.getTarget() : context.getTarget().getTargetOf("SiblingEntity");
    }

    private boolean isDraftEntity(DraftCancelEventContext context) {
        return context.getTarget().getQualifiedName().endsWith("_drafts");
    }

    private List<CdsData> readAttachments(DraftCancelEventContext context, CdsStructuredType entity, boolean isActiveEntity) {
        CqnDelete cqnInactiveEntity = (CqnDelete)CQL.copy((CqnStatement)context.getCqn(), (Modifier)this.activeEntityModifierProvider.getModifier(isActiveEntity, entity.getQualifiedName()));
        return this.attachmentsReader.readAttachments(context.getModel(), (CdsEntity)entity, (CqnFilterableStatement)cqnInactiveEntity);
    }

    private List<CdsData> getCondensedActiveAttachments(DraftCancelEventContext context, CdsStructuredType activeEntity) {
        List<CdsData> attachments = this.readAttachments(context, activeEntity, true);
        return ApplicationHandlerHelper.condenseData(attachments, context.getTarget());
    }

    private CdsDataProcessor.Filter buildContentIdFilter() {
        return (path, element, type) -> ApplicationHandlerHelper.isMediaEntity(path.target().type()) && element.getName().equals("contentId");
    }
}

