/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.draftservice;

import com.sap.cds.CdsData;
import com.sap.cds.CdsDataProcessor;
import com.sap.cds.Result;
import com.sap.cds.feature.attachments.handler.applicationservice.helper.ModifyApplicationHandlerHelper;
import com.sap.cds.feature.attachments.handler.applicationservice.processor.modifyevents.ModifyAttachmentEventFactory;
import com.sap.cds.feature.attachments.handler.common.ApplicationHandlerHelper;
import com.sap.cds.feature.attachments.utilities.LoggingMarker;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.draft.DraftPatchEventContext;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.persistence.PersistenceService;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

@ServiceName(value={"*"}, type={DraftService.class})
public class DraftPatchAttachmentsHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(DraftPatchAttachmentsHandler.class);
    private static final Marker marker = LoggingMarker.DRAFT_HANDLER.getMarker();
    private final PersistenceService persistence;
    private final ModifyAttachmentEventFactory eventFactory;

    public DraftPatchAttachmentsHandler(PersistenceService persistence, ModifyAttachmentEventFactory eventFactory) {
        this.persistence = persistence;
        this.eventFactory = eventFactory;
    }

    @Before
    @HandlerOrder(value=10000)
    public void processBeforeDraftPatch(DraftPatchEventContext context, List<CdsData> data) {
        logger.debug(marker, "Processing before draft patch event for entity {}", (Object)context.getTarget().getName());
        CdsDataProcessor.Converter converter = (path, element, value) -> {
            CdsEntity draftElement = path.target().entity().getQualifiedName().endsWith("_drafts") ? path.target().entity() : path.target().entity().getTargetOf("SiblingEntity");
            Select select = Select.from((String)draftElement.getQualifiedName()).matching(path.target().keys());
            Result result = this.persistence.run((CqnSelect)select, new Object[0]);
            return ModifyApplicationHandlerHelper.handleAttachmentForEntity(result.listOf(CdsData.class), this.eventFactory, (EventContext)context, path, (InputStream)value);
        };
        ApplicationHandlerHelper.callProcessor(context.getTarget(), data, ApplicationHandlerHelper.MEDIA_CONTENT_FILTER, converter);
    }
}

