/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.draftservice.modifier;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Literal;
import com.sap.cds.ql.RefBuilder;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveEntityModifier
implements Modifier {
    private static final Logger logger = LoggerFactory.getLogger(ActiveEntityModifier.class);
    private final boolean isActiveEntity;
    private final String fullEntityName;

    public ActiveEntityModifier(boolean isActiveEntity, String fullEntityName) {
        this.isActiveEntity = isActiveEntity;
        this.fullEntityName = fullEntityName;
    }

    public CqnStructuredTypeRef ref(CqnStructuredTypeRef original) {
        RefBuilder ref = CQL.copy((CqnStructuredTypeRef)original);
        RefBuilder.RefSegment rootSegment = ref.rootSegment();
        logger.debug("Modifying ref {} with isActiveEntity: {} and fullEntityName: {}", new Object[]{rootSegment, this.isActiveEntity, this.fullEntityName});
        rootSegment.id(this.fullEntityName);
        for (RefBuilder.RefSegment segment : ref.segments()) {
            if (!segment.filter().isPresent()) continue;
            segment.filter((CqnPredicate)CQL.copy((CqnPredicate)((CqnPredicate)segment.filter().orElseThrow()), (Modifier)new ActiveEntityModifier(this.isActiveEntity, this.fullEntityName)));
        }
        return (CqnStructuredTypeRef)ref.build();
    }

    public CqnPredicate comparison(Value<?> lhs, CqnComparisonPredicate.Operator op, Value<?> rhs) {
        Literal rhsNew = rhs;
        Literal lhsNew = lhs;
        if (lhs.isRef() && "IsActiveEntity".equals(lhs.asRef().lastSegment())) {
            rhsNew = CQL.constant((Object)this.isActiveEntity);
        }
        if (rhs.isRef() && "IsActiveEntity".equals(rhs.asRef().lastSegment())) {
            lhsNew = CQL.constant((Object)this.isActiveEntity);
        }
        return CQL.comparison(lhsNew, (CqnComparisonPredicate.Operator)op, rhsNew);
    }
}

