/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.service;

import com.sap.cds.feature.attachments.generated.cds4j.sap.attachments.MediaData;
import com.sap.cds.feature.attachments.service.AttachmentService;
import com.sap.cds.feature.attachments.service.model.service.AttachmentModificationResult;
import com.sap.cds.feature.attachments.service.model.service.CreateAttachmentInput;
import com.sap.cds.feature.attachments.service.model.service.MarkAsDeletedInput;
import com.sap.cds.feature.attachments.service.model.servicehandler.AttachmentCreateEventContext;
import com.sap.cds.feature.attachments.service.model.servicehandler.AttachmentMarkAsDeletedEventContext;
import com.sap.cds.feature.attachments.service.model.servicehandler.AttachmentReadEventContext;
import com.sap.cds.feature.attachments.service.model.servicehandler.AttachmentRestoreEventContext;
import com.sap.cds.feature.attachments.service.model.servicehandler.DeletionUserInfo;
import com.sap.cds.services.ServiceDelegator;
import com.sap.cds.services.request.UserInfo;
import java.io.InputStream;
import java.time.Instant;

public class AttachmentsServiceImpl
extends ServiceDelegator
implements AttachmentService {
    public AttachmentsServiceImpl() {
        super("AttachmentService$Default");
    }

    @Override
    public InputStream readAttachment(String contentId) {
        AttachmentReadEventContext readContext = AttachmentReadEventContext.create();
        readContext.setContentId(contentId);
        readContext.setData(MediaData.create());
        this.emit(readContext);
        return readContext.getData().getContent();
    }

    @Override
    public AttachmentModificationResult createAttachment(CreateAttachmentInput input) {
        AttachmentCreateEventContext createContext = AttachmentCreateEventContext.create();
        createContext.setAttachmentIds(input.attachmentIds());
        createContext.setAttachmentEntity(input.attachmentEntity());
        MediaData mediaData = MediaData.create();
        mediaData.setFileName(input.fileName());
        mediaData.setMimeType(input.mimeType());
        mediaData.setContent(input.content());
        createContext.setData(mediaData);
        this.emit(createContext);
        return new AttachmentModificationResult(Boolean.TRUE.equals(createContext.getIsInternalStored()), createContext.getContentId(), createContext.getData().getStatus());
    }

    @Override
    public void markAttachmentAsDeleted(MarkAsDeletedInput input) {
        AttachmentMarkAsDeletedEventContext deleteContext = AttachmentMarkAsDeletedEventContext.create();
        deleteContext.setContentId(input.contentId());
        deleteContext.setDeletionUserInfo(this.fillDeletionUserInfo(input.userInfo()));
        this.emit(deleteContext);
    }

    @Override
    public void restoreAttachment(Instant restoreTimestamp) {
        AttachmentRestoreEventContext restoreContext = AttachmentRestoreEventContext.create();
        restoreContext.setRestoreTimestamp(restoreTimestamp);
        this.emit(restoreContext);
    }

    private DeletionUserInfo fillDeletionUserInfo(UserInfo userInfo) {
        DeletionUserInfo deletionUserInfo = DeletionUserInfo.create();
        deletionUserInfo.setName(userInfo.getName());
        return deletionUserInfo;
    }
}

