/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.service.handler;

import com.sap.cds.feature.attachments.service.AttachmentService;
import com.sap.cds.feature.attachments.service.handler.transaction.EndTransactionMalwareScanProvider;
import com.sap.cds.feature.attachments.service.model.servicehandler.AttachmentCreateEventContext;
import com.sap.cds.feature.attachments.service.model.servicehandler.AttachmentMarkAsDeletedEventContext;
import com.sap.cds.feature.attachments.service.model.servicehandler.AttachmentReadEventContext;
import com.sap.cds.feature.attachments.service.model.servicehandler.AttachmentRestoreEventContext;
import com.sap.cds.feature.attachments.utilities.LoggingMarker;
import com.sap.cds.services.changeset.ChangeSetListener;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

@ServiceName(value={"*"}, type={AttachmentService.class})
public class DefaultAttachmentsServiceHandler
implements EventHandler {
    private static final int DEFAULT_ON = 11000;
    private static final Logger logger = LoggerFactory.getLogger(DefaultAttachmentsServiceHandler.class);
    private static final Marker marker = LoggingMarker.ATTACHMENT_SERVICE.getMarker();
    private final EndTransactionMalwareScanProvider endTransactionMalwareScanProvider;

    public DefaultAttachmentsServiceHandler(EndTransactionMalwareScanProvider endTransactionMalwareScanProvider) {
        this.endTransactionMalwareScanProvider = endTransactionMalwareScanProvider;
    }

    @On
    @HandlerOrder(value=11000)
    public void createAttachment(AttachmentCreateEventContext context) {
        logger.debug(marker, "Default Attachment Service handler called for creating attachment for entity '{}'", (Object)context.getAttachmentEntity().getQualifiedName());
        String contentId = (String)context.getAttachmentIds().get("ID");
        context.getData().setStatus("Scanning");
        ChangeSetListener listener = this.endTransactionMalwareScanProvider.getChangeSetListener(context.getAttachmentEntity(), contentId);
        context.getChangeSetContext().register(listener);
        context.setIsInternalStored(true);
        context.setContentId(contentId);
        context.setCompleted();
    }

    @On
    @HandlerOrder(value=11000)
    public void markAttachmentAsDeleted(AttachmentMarkAsDeletedEventContext context) {
        logger.debug(marker, "Default Attachment Service handler called for marking attachment as deleted with document id {}", (Object)context.getContentId());
        context.setCompleted();
    }

    @On
    @HandlerOrder(value=11000)
    public void restoreAttachment(AttachmentRestoreEventContext context) {
        logger.debug(marker, "Default Attachment Service handler called for restoring attachment for timestamp {}", (Object)context.getRestoreTimestamp());
        context.setCompleted();
    }

    @On
    @HandlerOrder(value=11000)
    public void readAttachment(AttachmentReadEventContext context) {
        logger.debug(marker, "Default Attachment Service handler called for reading attachment with document id {}", (Object)context.getContentId());
        context.setCompleted();
    }
}

