/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.service.handler.transaction;

import com.sap.cds.feature.attachments.service.malware.AsyncMalwareScanExecutor;
import com.sap.cds.feature.attachments.service.malware.AttachmentMalwareScanner;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.changeset.ChangeSetListener;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.RequestContextRunner;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record EndTransactionMalwareScanRunner(CdsEntity attachmentEntity, String contentId, AttachmentMalwareScanner attachmentMalwareScanner, CdsRuntime runtime) implements ChangeSetListener,
AsyncMalwareScanExecutor
{
    private static final Logger logger = LoggerFactory.getLogger(EndTransactionMalwareScanRunner.class);

    public void afterClose(boolean completed) {
        if (completed) {
            this.startScanning(this.attachmentEntity, this.contentId);
        }
    }

    @Override
    public void scanAsync(CdsEntity attachmentEntity, String contentId) {
        this.startScanning(attachmentEntity, contentId);
    }

    private void startScanning(CdsEntity attachmentEntityToScan, String contentId) {
        RequestContextRunner runner = this.runtime.requestContext();
        logger.debug("Transaction completed. Starting to scan attachment asynchronously.");
        Supplier<Void> executeAdapterSupplier = () -> {
            runner.run(resourceCtx -> this.runtime.changeSetContext().run(changeSetCtx -> {
                logger.info("Starting to scan attachment");
                this.attachmentMalwareScanner.scanAttachment(attachmentEntityToScan, contentId);
            }));
            return null;
        };
        CompletableFuture.supplyAsync(executeAdapterSupplier).whenComplete((result, exception) -> {
            if (Objects.nonNull(exception)) {
                logger.error("Error during scanning attachment", exception);
            } else {
                logger.info("Scanning attachment completed.");
            }
        });
    }
}

