/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.service.malware;

import com.sap.cds.CdsData;
import com.sap.cds.Result;
import com.sap.cds.feature.attachments.service.AttachmentService;
import com.sap.cds.feature.attachments.service.malware.AttachmentMalwareScanner;
import com.sap.cds.feature.attachments.service.malware.client.MalwareScanClient;
import com.sap.cds.feature.attachments.service.malware.client.mapper.MalwareClientStatusMapper;
import com.sap.cds.feature.attachments.service.malware.client.model.MalwareScanResultStatus;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Update;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.reflect.CdsElementNotFoundException;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.persistence.PersistenceService;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAttachmentMalwareScanner
implements AttachmentMalwareScanner {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAttachmentMalwareScanner.class);
    private final PersistenceService persistenceService;
    private final AttachmentService attachmentService;
    private final MalwareScanClient malwareScanClient;
    private final MalwareClientStatusMapper statusMapper;
    private final boolean isMalwareScanBound;

    public DefaultAttachmentMalwareScanner(PersistenceService persistenceService, AttachmentService attachmentService, MalwareScanClient malwareScanClient, MalwareClientStatusMapper statusMapper, boolean isMalwareScanBound) {
        this.persistenceService = persistenceService;
        this.attachmentService = attachmentService;
        this.malwareScanClient = malwareScanClient;
        this.statusMapper = statusMapper;
        this.isMalwareScanBound = isMalwareScanBound;
    }

    @Override
    public void scanAttachment(CdsEntity attachmentEntity, String contentId) {
        logger.info("Service handler called to scan document for malware");
        List<SelectionResult> selectionResult = this.selectData(attachmentEntity, contentId);
        selectionResult.forEach(result -> {
            long rowCount = result.result().rowCount();
            if (rowCount <= 0L) {
                logger.info("No data found, nothing to scan for entity: {}", (Object)result.entity.getQualifiedName());
                return;
            }
            if (rowCount > 1L) {
                logger.warn("More than one attachment found for document id: {} in entity: {}", (Object)contentId, (Object)result.entity.getQualifiedName());
                throw new IllegalStateException("More than one attachment found for document id: " + contentId);
            }
            CdsData cdsData = (CdsData)result.result().single(CdsData.class);
            MalwareScanResultStatus status = this.scanDocument(cdsData);
            this.updateData(result.entity, contentId, status);
        });
    }

    private List<SelectionResult> selectData(CdsEntity attachmentEntity, String contentId) {
        ArrayList<SelectionResult> result = new ArrayList<SelectionResult>();
        try {
            CdsEntity entity = (CdsEntity)attachmentEntity.getTargetOf("SiblingEntity");
            Result selectionResult = this.readData(contentId, entity);
            result.add(new SelectionResult(entity, selectionResult));
        }
        catch (CdsElementNotFoundException entity) {
            // empty catch block
        }
        Result selectionResult = this.readData(contentId, attachmentEntity);
        result.add(new SelectionResult(attachmentEntity, selectionResult));
        return result;
    }

    private Result readData(String contentId, CdsEntity entity) {
        Select select = Select.from((CdsEntity)entity).columns(new String[]{"contentId", "content"}).where(entry -> entry.get("contentId").eq((Object)contentId));
        return this.persistenceService.run((CqnSelect)select, new Object[0]);
    }

    private MalwareScanResultStatus scanDocument(CdsData data) {
        if (this.isMalwareScanBound) {
            String contentId = (String)data.get((Object)"contentId");
            InputStream dbContent = (InputStream)data.get((Object)"content");
            try {
                InputStream content = Objects.nonNull(dbContent) ? dbContent : this.attachmentService.readAttachment(contentId);
                return this.malwareScanClient.scanContent(content);
            }
            catch (RuntimeException e) {
                logger.error("Error while scanning document with document id: {}", (Object)contentId, (Object)e);
                return MalwareScanResultStatus.FAILED;
            }
        }
        return MalwareScanResultStatus.NO_SCANNER;
    }

    private void updateData(CdsEntity attachmentEntity, String contentId, MalwareScanResultStatus status) {
        CdsData updateData = CdsData.create();
        updateData.put((Object)"status", (Object)this.statusMapper.mapStatus(status));
        updateData.put((Object)"scannedAt", (Object)Instant.now());
        logger.debug("CdsData shall be updated for entity: {}", (Object)attachmentEntity.getQualifiedName());
        Update update = Update.entity((CdsEntity)attachmentEntity).data((Map)updateData).where(entry -> entry.get("contentId").eq((Object)contentId));
        Result result = this.persistenceService.run((CqnUpdate)update, new Object[0]);
        logger.info("Attachment has been updated, with result row count {} for entity {}", (Object)result.rowCount(), (Object)attachmentEntity.getQualifiedName());
    }

    private record SelectionResult(CdsEntity entity, Result result) {
    }
}

